/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;

public class PartialInputStream
extends InputStream {
    private final InputStream backingInputStream;
    private final long bytesRequiredToSkip;
    private long bytesSkipped;

    public PartialInputStream(InputStream backingInputStream, long start) {
        this.backingInputStream = backingInputStream;
        this.bytesRequiredToSkip = start;
    }

    @Override
    public int read() throws IOException {
        this.throwIfMissingBufferNotSkipped();
        return this.backingInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.throwIfMissingBufferNotSkipped();
        return super.read(b);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        this.throwIfMissingBufferNotSkipped();
        return super.readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        this.throwIfMissingBufferNotSkipped();
        return super.readNBytes(len);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        this.throwIfMissingBufferNotSkipped();
        return super.transferTo(out);
    }

    @Override
    public void close() throws IOException {
        this.backingInputStream.close();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.bytesSkipped < this.bytesRequiredToSkip) {
            long bytesToSkip = Math.min(this.bytesRequiredToSkip - this.bytesSkipped, n);
            this.bytesSkipped += bytesToSkip;
            return bytesToSkip;
        }
        return this.backingInputStream.skip(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    private void throwIfMissingBufferNotSkipped() throws IOException {
        if (this.bytesSkipped != this.bytesRequiredToSkip) {
            throw new IOException("You must skip over the partial (missing) portion of this input stream");
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartialInputStream)) {
            return false;
        }
        PartialInputStream other = (PartialInputStream)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.bytesRequiredToSkip != other.bytesRequiredToSkip) {
            return false;
        }
        if (this.bytesSkipped != other.bytesSkipped) {
            return false;
        }
        InputStream this$backingInputStream = this.backingInputStream;
        InputStream other$backingInputStream = other.backingInputStream;
        return !(this$backingInputStream == null ? other$backingInputStream != null : !this$backingInputStream.equals(other$backingInputStream));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PartialInputStream;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $bytesRequiredToSkip = this.bytesRequiredToSkip;
        result = result * 59 + (int)($bytesRequiredToSkip >>> 32 ^ $bytesRequiredToSkip);
        long $bytesSkipped = this.bytesSkipped;
        result = result * 59 + (int)($bytesSkipped >>> 32 ^ $bytesSkipped);
        InputStream $backingInputStream = this.backingInputStream;
        result = result * 59 + ($backingInputStream == null ? 43 : $backingInputStream.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PartialInputStream(backingInputStream=" + this.backingInputStream + ", bytesRequiredToSkip=" + this.bytesRequiredToSkip + ", bytesSkipped=" + this.bytesSkipped + ")";
    }
}

