/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage;

import engineering.everest.starterkit.filestorage.InputStreamOfKnownLength;
import engineering.everest.starterkit.filestorage.PersistedFileIdentifier;
import engineering.everest.starterkit.filestorage.filestores.EphemeralDeduplicatingFileStore;
import engineering.everest.starterkit.filestorage.filestores.FileStoreType;
import engineering.everest.starterkit.filestorage.filestores.PermanentDeduplicatingFileStore;
import engineering.everest.starterkit.filestorage.persistence.FileMappingRepository;
import engineering.everest.starterkit.filestorage.persistence.PersistableFileMapping;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class FileService {
    private final FileMappingRepository fileMappingRepository;
    private final PermanentDeduplicatingFileStore permanentDeduplicatingFileStore;
    private final EphemeralDeduplicatingFileStore ephemeralDeduplicatingFileStore;

    public FileService(FileMappingRepository fileMappingRepository, PermanentDeduplicatingFileStore permanentDeduplicatingFileStore, EphemeralDeduplicatingFileStore ephemeralDeduplicatingFileStore) {
        this.fileMappingRepository = fileMappingRepository;
        this.permanentDeduplicatingFileStore = permanentDeduplicatingFileStore;
        this.ephemeralDeduplicatingFileStore = ephemeralDeduplicatingFileStore;
    }

    public File createTemporaryFile(String suffix) throws IOException {
        File tempFile = Files.createTempFile("temp", suffix, new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        return tempFile;
    }

    public UUID transferToPermanentStore(String originalFilename, InputStream inputStream) throws IOException {
        return this.permanentDeduplicatingFileStore.uploadAsStream(originalFilename, inputStream).getPersistedFileIdentifier().getFileId();
    }

    public UUID transferToEphemeralStore(String filename, InputStream inputStream) throws IOException {
        return this.ephemeralDeduplicatingFileStore.uploadAsStream(filename, inputStream).getPersistedFileIdentifier().getFileId();
    }

    public UUID transferToEphemeralStore(InputStream inputStream) throws IOException {
        return this.transferToEphemeralStore("", inputStream);
    }

    public long fileSizeInBytes(UUID fileId) {
        return ((PersistableFileMapping)this.fileMappingRepository.findById(fileId).orElseThrow()).getFileSizeBytes();
    }

    public InputStreamOfKnownLength stream(UUID fileId) throws IOException {
        return this.stream(fileId, 0L);
    }

    public InputStreamOfKnownLength stream(UUID fileId, long startingOffset) throws IOException {
        return this.stream(fileId, startingOffset, this.fileSizeInBytes(fileId));
    }

    public InputStreamOfKnownLength stream(UUID fileId, long startingOffset, long endingOffset) throws IOException {
        PersistableFileMapping persistableFileMapping = (PersistableFileMapping)this.fileMappingRepository.findById(fileId).orElseThrow();
        PermanentDeduplicatingFileStore fileStore = persistableFileMapping.getFileStoreType().equals((Object)FileStoreType.PERMANENT) ? this.permanentDeduplicatingFileStore : this.ephemeralDeduplicatingFileStore;
        return fileStore.downloadAsStream(persistableFileMapping, startingOffset, endingOffset);
    }

    public void markEphemeralFilesForDeletion(Set<UUID> fileIds) {
        List<PersistedFileIdentifier> persistedFileIdentifiers = this.fileMappingRepository.findAllById(fileIds).stream().map(PersistableFileMapping::getPersistedFileIdentifier).collect(Collectors.toList());
        this.ephemeralDeduplicatingFileStore.markFilesForDeletion(persistedFileIdentifiers);
    }

    public void markEphemeralFileForDeletion(UUID fileId) {
        PersistableFileMapping persistableFileMapping = (PersistableFileMapping)this.fileMappingRepository.findById(fileId).orElseThrow();
        this.ephemeralDeduplicatingFileStore.markFileForDeletion(persistableFileMapping.getPersistedFileIdentifier());
    }

    public void markAllEphemeralFilesForDeletion() {
        this.ephemeralDeduplicatingFileStore.markAllFilesForDeletion();
    }

    public void deleteEphemeralFileBatch(int batchSize) {
        this.ephemeralDeduplicatingFileStore.deleteFileBatch(batchSize);
    }
}

