/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage.backing;

import engineering.everest.starterkit.filestorage.BackingStorageType;
import engineering.everest.starterkit.filestorage.BackingStore;
import engineering.everest.starterkit.filestorage.InputStreamOfKnownLength;
import engineering.everest.starterkit.filestorage.backing.BackingFileStoreException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;

public class InMemoryBackingStore
implements BackingStore {
    private final Map<String, Metadata> fileMapping = new HashMap<String, Metadata>();

    @Override
    public String uploadStream(InputStream inputStream, String fileName) {
        try {
            byte[] contents = inputStream.readAllBytes();
            String id = UUID.randomUUID().toString();
            this.fileMapping.put(id, new Metadata(contents.length, contents));
            return id;
        }
        catch (IOException e) {
            throw new BackingFileStoreException("Unable to upload file " + fileName, e);
        }
    }

    @Override
    public String uploadStream(InputStream inputStream, String fileName, long fileSize) {
        try {
            byte[] contents = inputStream.readAllBytes();
            this.throwIfContentLengthNotExpectedFileSize(fileName, fileSize, contents);
            String id = UUID.randomUUID().toString();
            this.fileMapping.put(id, new Metadata(fileSize, contents));
            return id;
        }
        catch (IOException e) {
            throw new BackingFileStoreException("Unable to upload file " + fileName, e);
        }
    }

    @Override
    public void delete(String fileIdentifier) {
        this.fileMapping.remove(fileIdentifier);
    }

    @Override
    public void deleteFiles(Set<String> fileIdentifiers) {
        fileIdentifiers.forEach(this.fileMapping::remove);
    }

    @Override
    public InputStreamOfKnownLength downloadAsStream(String fileIdentifier) throws IOException {
        this.throwIfFileNotInFilestore(fileIdentifier);
        Metadata fileMetadata = this.fileMapping.get(fileIdentifier);
        return new InputStreamOfKnownLength(new ByteArrayInputStream(fileMetadata.getContent()), fileMetadata.getLength());
    }

    @Override
    public BackingStorageType backingStorageType() {
        return BackingStorageType.IN_MEMORY;
    }

    private void throwIfFileNotInFilestore(String fileIdentifier) {
        if (!this.fileMapping.containsKey(fileIdentifier)) {
            throw new BackingFileStoreException(String.format("File '%s' not in filestore", fileIdentifier));
        }
    }

    private void throwIfContentLengthNotExpectedFileSize(String fileName, long fileSize, byte[] contents) {
        if (fileSize != (long)contents.length) {
            throw new BackingFileStoreException(String.format("Expected file size %d for uploaded file '%s' but content length is %d", fileSize, fileName, contents.length));
        }
    }

    static class Metadata {
        private final long length;
        private final byte[] content;

        @Generated
        public Metadata(long length, byte[] content) {
            this.length = length;
            this.content = content;
        }

        @Generated
        public long getLength() {
            return this.length;
        }

        @Generated
        public byte[] getContent() {
            return this.content;
        }
    }
}

