/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.media.thumbnails;

import engineering.everest.starterkit.filestorage.FileService;
import engineering.everest.starterkit.media.thumbnails.persistence.PersistableThumbnail;
import engineering.everest.starterkit.media.thumbnails.persistence.PersistableThumbnailMapping;
import engineering.everest.starterkit.media.thumbnails.persistence.ThumbnailMappingRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ThumbnailService {
    private final int maxDimensionPixels;
    private final FileService fileService;
    private final ThumbnailMappingRepository thumbnailMappingRepository;

    @Autowired
    public ThumbnailService(@Value(value="${application.media.thumbnail.max.dimension.pixels:2400}") int maxDimensionPixels, FileService fileService, ThumbnailMappingRepository thumbnailMappingRepository) {
        this.maxDimensionPixels = maxDimensionPixels;
        this.fileService = fileService;
        this.thumbnailMappingRepository = thumbnailMappingRepository;
    }

    public InputStream streamThumbnailForOriginalFile(UUID fileId, int width, int height) throws IOException {
        Optional<PersistableThumbnail> existingMapping = this.findExistingThumbnail(fileId, width, height);
        UUID thumbnailFileId = existingMapping.isPresent() ? existingMapping.get().getThumbnailFileId() : this.createThumbnailForOriginalFile(fileId, width, height);
        return this.fileService.stream(thumbnailFileId).getInputStream();
    }

    public void deleteAllThumbnailMappings() {
        this.thumbnailMappingRepository.deleteAll();
    }

    private Optional<PersistableThumbnail> findExistingThumbnail(UUID fileId, int width, int height) {
        Optional thumbnailMapping = this.thumbnailMappingRepository.findById(fileId);
        if (thumbnailMapping.isPresent()) {
            return ((PersistableThumbnailMapping)thumbnailMapping.get()).getThumbnails().stream().filter(x -> x.getWidth() == width && x.getHeight() == height).findFirst();
        }
        return Optional.empty();
    }

    /*
     * Exception decompiling
     */
    private UUID createThumbnailForOriginalFile(UUID fileId, int width, int height) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void throwIfThumbnailDimensionsUnreasonable(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Thumbnail dimension can't be less than 1");
        }
        if (width > this.maxDimensionPixels || height > this.maxDimensionPixels) {
            throw new IllegalArgumentException(String.format("Thumbnail dimension cannot exceed %s pixels", this.maxDimensionPixels));
        }
    }

    private UUID persistThumbnailAndUpdateMapping(UUID originalFileId, int width, int height, File tempFile, String thumbnailFilename) throws IOException {
        try (InputStream thumbnailInputStream = Files.newInputStream(tempFile.toPath(), new OpenOption[0]);){
            UUID thumbnailFileID = this.fileService.transferToEphemeralStore(thumbnailFilename, thumbnailInputStream);
            PersistableThumbnailMapping thumbnailMapping = this.thumbnailMappingRepository.findById(originalFileId).orElseGet(() -> new PersistableThumbnailMapping(originalFileId, new ArrayList<PersistableThumbnail>()));
            thumbnailMapping.addThumbnail(thumbnailFileID, width, height);
            this.thumbnailMappingRepository.save(thumbnailMapping);
            UUID uUID = thumbnailFileID;
            return uUID;
        }
    }
}

