/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.media.metadata;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import engineering.everest.starterkit.filestorage.FileService;
import engineering.everest.starterkit.filestorage.InputStreamOfKnownLength;
import engineering.everest.starterkit.media.metadata.MediaDimensions;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MediaDimensionsExtractor {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private final FileService fileService;

    @Autowired
    public MediaDimensionsExtractor(FileService fileService) {
        this.fileService = fileService;
    }

    public MediaDimensions getMediaDimension(UUID fileId) throws Exception {
        HashMap<String, Integer> dimensionsMap = new HashMap<String, Integer>();
        try (InputStreamOfKnownLength streamOfKnownLength = this.fileService.stream(fileId);){
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)streamOfKnownLength.getInputStream(), (long)streamOfKnownLength.getLength());
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    this.updateWidthOrHeightIfTagIsRelevant(dimensionsMap, directory, tag);
                }
            }
        }
        return new MediaDimensions((Integer)dimensionsMap.get(WIDTH_KEY), (Integer)dimensionsMap.get(HEIGHT_KEY));
    }

    private void updateWidthOrHeightIfTagIsRelevant(Map<String, Integer> dimensionsMap, Directory directory, Tag tag) {
        String tagName = tag.getTagName().toLowerCase();
        try {
            if (tagName.contains(WIDTH_KEY)) {
                this.setValueIfGreater(dimensionsMap, WIDTH_KEY, directory, tag);
            } else if (tagName.contains(HEIGHT_KEY)) {
                this.setValueIfGreater(dimensionsMap, HEIGHT_KEY, directory, tag);
            }
        }
        catch (MetadataException e) {
            throw new RuntimeException(e);
        }
    }

    private void setValueIfGreater(Map<String, Integer> dimensionsMap, String key, Directory directory, Tag tag) throws MetadataException {
        int newValue = directory.getInt(tag.getTagType());
        if (newValue > dimensionsMap.getOrDefault(key, -1)) {
            dimensionsMap.put(key, newValue);
        }
    }
}

