/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.axon.cryptoshredding.serialization;

import engineering.everest.axon.cryptoshredding.exceptions.UnsupportedEncryptionKeyIdentifierTypeException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class KeyIdentifierToStringConverter {
    private final Map<Class<?>, Function<Object, String>> customKeyIdentifierStringConverters;

    public KeyIdentifierToStringConverter() {
        this.customKeyIdentifierStringConverters = new HashMap();
    }

    private KeyIdentifierToStringConverter(Builder builder) {
        this.customKeyIdentifierStringConverters = builder.customKeyIdentifierStringConverters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String convertToString(Object object) {
        if (object instanceof String || object instanceof UUID || object instanceof Long || object instanceof Integer) {
            return object.toString();
        }
        if (this.customKeyIdentifierStringConverters.containsKey(object.getClass())) {
            return this.customKeyIdentifierStringConverters.get(object.getClass()).apply(object);
        }
        throw new UnsupportedEncryptionKeyIdentifierTypeException(object.toString());
    }

    public static class Builder {
        private final Map<Class<?>, Function<Object, String>> customKeyIdentifierStringConverters = new HashMap();

        public Builder customConverter(Class clazz, Function<Object, String> conversionFunction) {
            this.customKeyIdentifierStringConverters.put(clazz, conversionFunction);
            return this;
        }

        public KeyIdentifierToStringConverter build() {
            return new KeyIdentifierToStringConverter(this);
        }
    }
}

