/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.axon.cryptoshredding.serialization;

import java.util.HashMap;
import java.util.Map;

public class DefaultValueProvider {
    private static final Double DOUBLE_0 = 0.0;
    private static final Float FLOAT_0 = Float.valueOf(0.0f);
    private final Map<Class<?>, Object> customDefaultValueTypes;

    public DefaultValueProvider() {
        this.customDefaultValueTypes = new HashMap();
    }

    private DefaultValueProvider(Builder builder) {
        this.customDefaultValueTypes = builder.customDefaultValueTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T defaultValue(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Default value for null class doesn't make sense");
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (clazz == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            if (clazz == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (clazz == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (clazz == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (clazz == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (clazz == Float.TYPE) {
                return (T)FLOAT_0;
            }
            if (clazz == Double.TYPE) {
                return (T)DOUBLE_0;
            }
        }
        return (T)this.customDefaultValueTypes.get(clazz);
    }

    public static class Builder {
        private final Map<Class<?>, Object> customDefaultValueTypes = new HashMap();

        public <T> Builder customType(Class<T> clazz, Object defaultValue) {
            this.customDefaultValueTypes.put(clazz, defaultValue);
            return this;
        }

        public DefaultValueProvider build() {
            return new DefaultValueProvider(this);
        }
    }
}

