/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.axon.cryptoshredding.encryption;

import engineering.everest.axon.cryptoshredding.encryption.Encrypter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class DefaultAesEncrypter
implements Encrypter {
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final int INITIALIZATION_VECTOR_LENGTH_BYTES = 12;
    private static final int AUTHENTICATION_TAG_SIZE_BITS = 128;
    private final SecureRandom secureRandom;

    public DefaultAesEncrypter(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    @Override
    public byte[] encrypt(SecretKey secretKey, String cleartext) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            byte[] initializationVector = this.createInitializationVector();
            cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, initializationVector), this.secureRandom);
            return this.concatInitializationVectorAndCipherText(initializationVector, cipher.doFinal(cleartext.getBytes()));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] createInitializationVector() {
        byte[] initializationVector = new byte[12];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }

    private byte[] concatInitializationVectorAndCipherText(byte[] initializationVector, byte[] cipherText) {
        byte[] initializationVectorWithCipherText = new byte[initializationVector.length + cipherText.length];
        System.arraycopy(initializationVector, 0, initializationVectorWithCipherText, 0, 12);
        System.arraycopy(cipherText, 0, initializationVectorWithCipherText, initializationVector.length, cipherText.length);
        return initializationVectorWithCipherText;
    }
}

