/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.axon.cryptoshredding.config;

import engineering.everest.axon.cryptoshredding.CryptoShreddingKeyService;
import engineering.everest.axon.cryptoshredding.encryption.DefaultAesEncrypterDecrypterFactory;
import engineering.everest.axon.cryptoshredding.encryption.DefaultAesKeyGenerator;
import engineering.everest.axon.cryptoshredding.encryption.EncrypterDecrypterFactory;
import engineering.everest.axon.cryptoshredding.encryption.KeyGenerator;
import engineering.everest.axon.cryptoshredding.persistence.SecretKeyRepository;
import engineering.everest.axon.cryptoshredding.serialization.DefaultValueProvider;
import engineering.everest.axon.cryptoshredding.serialization.KeyIdentifierToStringConverter;
import java.security.NoSuchAlgorithmException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(name={"org.axonframework.springboot.autoconfig.AxonAutoConfiguration"})
public class AxonCryptoShreddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={EncrypterDecrypterFactory.class})
    public EncrypterDecrypterFactory encrypterDecrypterFactory() {
        return new DefaultAesEncrypterDecrypterFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={KeyGenerator.class})
    public KeyGenerator keyGenerator() throws NoSuchAlgorithmException {
        return new DefaultAesKeyGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultValueProvider.class})
    public DefaultValueProvider defaultValueProvider() {
        return new DefaultValueProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={KeyIdentifierToStringConverter.class})
    public KeyIdentifierToStringConverter keyIdentifierToStringConverter() {
        return new KeyIdentifierToStringConverter();
    }

    @Bean
    @ConditionalOnMissingBean(value={CryptoShreddingKeyService.class})
    public CryptoShreddingKeyService cryptoShreddingKeyService(SecretKeyRepository secretKeyRepository, KeyGenerator keyGenerator) {
        return new CryptoShreddingKeyService(secretKeyRepository, keyGenerator);
    }
}

