/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.axon.cryptoshredding;

import engineering.everest.axon.cryptoshredding.TypeDifferentiatedSecretKeyId;
import engineering.everest.axon.cryptoshredding.encryption.KeyGenerator;
import engineering.everest.axon.cryptoshredding.exceptions.MissingEncryptionKeyRecordException;
import engineering.everest.axon.cryptoshredding.persistence.PersistableSecretKey;
import engineering.everest.axon.cryptoshredding.persistence.SecretKeyRepository;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CryptoShreddingKeyService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoShreddingKeyService.class);
    private final SecretKeyRepository secretKeyRepository;
    private final KeyGenerator secretKeyGenerator;

    public CryptoShreddingKeyService(SecretKeyRepository secretKeyRepository, KeyGenerator secretKeyGenerator) {
        this.secretKeyRepository = secretKeyRepository;
        this.secretKeyGenerator = secretKeyGenerator;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public Optional<SecretKey> getOrCreateSecretKeyUnlessDeleted(TypeDifferentiatedSecretKeyId keyId) {
        Optional optionalPersistableSecretKey = this.secretKeyRepository.findById(keyId);
        if (optionalPersistableSecretKey.isEmpty()) {
            LOGGER.trace("Creating crypto shredding key {}", (Object)keyId.toString());
            return Optional.of(this.secretKeyRepository.create(keyId, this.secretKeyGenerator.generateKey()));
        }
        return this.createSecretKeyOrEmptyOptional((PersistableSecretKey)optionalPersistableSecretKey.get());
    }

    public boolean secretKeyExists(TypeDifferentiatedSecretKeyId keyId) {
        return this.secretKeyRepository.findById(keyId).isPresent();
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public Optional<SecretKey> getExistingSecretKey(TypeDifferentiatedSecretKeyId keyId) {
        Optional optionalPersistableSecretKey = this.secretKeyRepository.findById(keyId);
        if (optionalPersistableSecretKey.isEmpty()) {
            throw new MissingEncryptionKeyRecordException(keyId.getKeyId(), keyId.getKeyType());
        }
        LOGGER.trace("Retrieved crypto shredding key {}", (Object)keyId.toString());
        return this.createSecretKeyOrEmptyOptional((PersistableSecretKey)optionalPersistableSecretKey.get());
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void shredSecretKey(TypeDifferentiatedSecretKeyId keyId) {
        Optional optionalSecretKey = this.secretKeyRepository.findById(keyId);
        PersistableSecretKey secretKey = (PersistableSecretKey)optionalSecretKey.orElseThrow(() -> new MissingEncryptionKeyRecordException(keyId.getKeyId(), keyId.getKeyType()));
        if (secretKey.getKey() != null || secretKey.getAlgorithm() != null) {
            secretKey.setAlgorithm(null);
            secretKey.setKey(null);
            this.secretKeyRepository.save(secretKey);
            LOGGER.trace("Permanently deleted crypto shredding key {}", (Object)keyId.toString());
        }
    }

    private Optional<SecretKey> createSecretKeyOrEmptyOptional(PersistableSecretKey persistableSecretKey) {
        if (persistableSecretKey.getAlgorithm() == null || persistableSecretKey.getKey() == null) {
            return Optional.empty();
        }
        return Optional.of(new SecretKeySpec(persistableSecretKey.getKey(), persistableSecretKey.getAlgorithm()));
    }
}

