/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.axon.cryptoshredding.encryption;

import engineering.everest.axon.cryptoshredding.encryption.Decrypter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

class DefaultAesDecrypter
implements Decrypter {
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final int INITIALIZATION_VECTOR_LENGTH_BYTES = 12;
    private static final int AUTHENTICATION_TAG_SIZE_BITS = 128;
    private final SecureRandom secureRandom;

    public DefaultAesDecrypter(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    @Override
    public String decrypt(SecretKey secretKey, byte[] initializationVectorAndCipherText) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, (Key)secretKey, new GCMParameterSpec(128, initializationVectorAndCipherText, 0, 12), this.secureRandom);
            return new String(cipher.doFinal(initializationVectorAndCipherText, 12, initializationVectorAndCipherText.length - 12));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }
}

