/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.axon.cryptoshredding;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Defaults;
import engineering.everest.axon.cryptoshredding.CryptoShreddingKeyService;
import engineering.everest.axon.cryptoshredding.TypeDifferentiatedSecretKeyId;
import engineering.everest.axon.cryptoshredding.annotations.EncryptedField;
import engineering.everest.axon.cryptoshredding.annotations.EncryptionKeyIdentifier;
import engineering.everest.axon.cryptoshredding.encryption.Decrypter;
import engineering.everest.axon.cryptoshredding.encryption.Encrypter;
import engineering.everest.axon.cryptoshredding.encryption.EncrypterDecrypterFactory;
import engineering.everest.axon.cryptoshredding.exceptions.DuplicateEncryptionKeyIdentifierFieldTagException;
import engineering.everest.axon.cryptoshredding.exceptions.EncryptionKeyDeletedException;
import engineering.everest.axon.cryptoshredding.exceptions.MissingEncryptionKeyIdentifierAnnotationException;
import engineering.everest.axon.cryptoshredding.exceptions.MissingSerializedEncryptionKeyIdentifierFieldException;
import engineering.everest.axon.cryptoshredding.exceptions.MissingTaggedEncryptionKeyIdentifierException;
import engineering.everest.axon.cryptoshredding.exceptions.UnsupportedEncryptionKeyIdentifierTypeException;
import java.lang.reflect.Field;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.axonframework.common.ObjectUtils;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class CryptoShreddingSerializer
implements Serializer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoShreddingSerializer.class);
    private final Serializer wrappedSerializer;
    private final CryptoShreddingKeyService cryptoShreddingKeyService;
    private final EncrypterDecrypterFactory encrypterDecrypterFactory;
    private final ObjectMapper objectMapper;

    public CryptoShreddingSerializer(@Qualifier(value="eventSerializer") Serializer wrappedSerializer, CryptoShreddingKeyService cryptoShreddingKeyService, EncrypterDecrypterFactory encrypterDecrypterFactory, ObjectMapper objectMapper) {
        this.wrappedSerializer = wrappedSerializer;
        this.cryptoShreddingKeyService = cryptoShreddingKeyService;
        this.encrypterDecrypterFactory = encrypterDecrypterFactory;
        this.objectMapper = objectMapper;
    }

    public <T> SerializedObject<T> serialize(Object object, Class<T> expectedRepresentation) {
        List<Field> fields = List.of(object.getClass().getDeclaredFields());
        List<Field> encryptedFields = this.getEncryptedFields(fields);
        if (encryptedFields.isEmpty()) {
            return this.wrappedSerializer.serialize(object, expectedRepresentation);
        }
        Map<String, SecretKey> fieldToSecretKeyMapping = this.retrieveOrCreateSecretKeysForSerialization(object, fields);
        Map<String, Object> encryptedMappedObject = this.mapAndEncryptAnnotatedFields(object, encryptedFields, fieldToSecretKeyMapping);
        SerializedObject serializedObject = this.wrappedSerializer.serialize(encryptedMappedObject, expectedRepresentation);
        return new SimpleSerializedObject(serializedObject.getData(), expectedRepresentation, this.wrappedSerializer.typeForClass(ObjectUtils.nullSafeTypeOf((Object)object)));
    }

    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return this.wrappedSerializer.canSerializeTo(expectedRepresentation);
    }

    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        Class<?> classToDeserialize = this.getClassToDeserialize(serializedObject);
        List<Field> fields = List.of(classToDeserialize.getDeclaredFields());
        List<Field> encryptedFields = this.getEncryptedFields(fields);
        if (encryptedFields.isEmpty()) {
            return (T)this.wrappedSerializer.deserialize(serializedObject);
        }
        SimpleSerializedType encryptedSerializedType = new SimpleSerializedType(HashMap.class.getCanonicalName(), serializedObject.getType().getRevision());
        SimpleSerializedObject encryptedSerializedObject = new SimpleSerializedObject(serializedObject.getData(), serializedObject.getContentType(), (SerializedType)encryptedSerializedType);
        Map encryptedMappedObject = (Map)this.wrappedSerializer.deserialize((SerializedObject)encryptedSerializedObject);
        Map<String, String> serializedFieldNameMapping = this.buildFieldNamingSerializationStrategyIndependentMapping(encryptedMappedObject);
        Map<String, Optional<SecretKey>> fieldTagToSecretKeyMapping = this.retrieveSecretKeysForDeserialization(encryptedMappedObject, serializedFieldNameMapping, fields);
        Map<String, Object> mappedObject = this.decryptAnnotatedFields(encryptedMappedObject, serializedFieldNameMapping, encryptedFields, fieldTagToSecretKeyMapping);
        return (T)this.objectMapper.convertValue(mappedObject, classToDeserialize);
    }

    public Class classForType(SerializedType type) {
        return this.wrappedSerializer.classForType(type);
    }

    public SerializedType typeForClass(Class type) {
        return this.wrappedSerializer.typeForClass(type);
    }

    public Converter getConverter() {
        return this.wrappedSerializer.getConverter();
    }

    private List<Field> getEncryptedFields(List<Field> fields) {
        return fields.stream().filter(field -> field.getAnnotation(EncryptedField.class) != null).toList();
    }

    private Map<String, SecretKey> retrieveOrCreateSecretKeysForSerialization(Object object, List<Field> fields) {
        List<Field> secretKeyIdentifierFields = this.findSecretKeyIdentifierFields(fields);
        if (secretKeyIdentifierFields.isEmpty()) {
            throw new MissingEncryptionKeyIdentifierAnnotationException();
        }
        HashMap<String, SecretKey> fieldTagToSecretKeyMapping = new HashMap<String, SecretKey>();
        secretKeyIdentifierFields.forEach(field -> {
            TypeDifferentiatedSecretKeyId secretKeyIdentifier = this.extractSecretKeyIdentifier(object, (Field)field);
            Optional<SecretKey> optionalSecretKey = this.cryptoShreddingKeyService.getOrCreateSecretKeyUnlessDeleted(secretKeyIdentifier);
            String fieldTag = field.getAnnotation(EncryptionKeyIdentifier.class).tag();
            if (fieldTagToSecretKeyMapping.containsKey(fieldTag)) {
                throw new DuplicateEncryptionKeyIdentifierFieldTagException(field.getName(), fieldTag);
            }
            fieldTagToSecretKeyMapping.put(fieldTag, optionalSecretKey.orElseThrow(() -> new EncryptionKeyDeletedException(secretKeyIdentifier.getKeyId(), secretKeyIdentifier.getKeyType())));
        });
        return fieldTagToSecretKeyMapping;
    }

    private Map<String, Optional<SecretKey>> retrieveSecretKeysForDeserialization(Map<String, Object> encryptedMappedObject, Map<String, String> serializedFieldNameMapping, List<Field> fields) {
        List<Field> secretKeyIdentifierFields = this.findSecretKeyIdentifierFields(fields);
        if (secretKeyIdentifierFields.isEmpty()) {
            throw new MissingEncryptionKeyIdentifierAnnotationException();
        }
        HashMap<String, Optional<SecretKey>> fieldTagToSecretKeyMapping = new HashMap<String, Optional<SecretKey>>();
        secretKeyIdentifierFields.forEach(field -> {
            EncryptionKeyIdentifier encryptionKeyIdentifierAnnotation = field.getAnnotation(EncryptionKeyIdentifier.class);
            String secretKeyIdentifierFieldName = (String)serializedFieldNameMapping.get(field.getName().toLowerCase());
            if (secretKeyIdentifierFieldName == null) {
                throw new MissingSerializedEncryptionKeyIdentifierFieldException();
            }
            String secretKeyIdentifier = encryptedMappedObject.get(secretKeyIdentifierFieldName).toString();
            if (secretKeyIdentifier == null || secretKeyIdentifier.isBlank()) {
                throw new MissingSerializedEncryptionKeyIdentifierFieldException();
            }
            Optional<SecretKey> secretKey = this.cryptoShreddingKeyService.getExistingSecretKey(new TypeDifferentiatedSecretKeyId(secretKeyIdentifier, encryptionKeyIdentifierAnnotation.keyType()));
            fieldTagToSecretKeyMapping.put(encryptionKeyIdentifierAnnotation.tag(), secretKey);
        });
        return fieldTagToSecretKeyMapping;
    }

    private List<Field> findSecretKeyIdentifierFields(List<Field> fields) {
        return fields.stream().filter(field -> field.getAnnotation(EncryptionKeyIdentifier.class) != null).toList();
    }

    private TypeDifferentiatedSecretKeyId extractSecretKeyIdentifier(Object object, Field secretKeyIdentifierField) {
        secretKeyIdentifierField.setAccessible(true);
        try {
            return new TypeDifferentiatedSecretKeyId(this.convertToString(secretKeyIdentifierField.get(object)), secretKeyIdentifierField.getAnnotation(EncryptionKeyIdentifier.class).keyType());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String convertToString(Object object) {
        if (object instanceof String || object instanceof UUID || object instanceof Long || object instanceof Integer) {
            return object.toString();
        }
        throw new UnsupportedEncryptionKeyIdentifierTypeException(object.toString());
    }

    private Map<String, Object> mapAndEncryptAnnotatedFields(Object object, List<Field> encryptedFields, Map<String, SecretKey> fieldTagToSecretKeyMapping) {
        HashMap mappedObject = (HashMap)this.objectMapper.convertValue(object, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        Map<String, String> serializedFieldNameMapping = this.buildFieldNamingSerializationStrategyIndependentMapping(mappedObject);
        Encrypter encrypter = this.encrypterDecrypterFactory.createEncrypter();
        encryptedFields.forEach(field -> {
            String fieldKey = (String)serializedFieldNameMapping.get(field.getName().toLowerCase());
            String fieldTag = field.getAnnotation(EncryptedField.class).tag();
            if (!fieldTagToSecretKeyMapping.containsKey(fieldTag)) {
                throw new MissingTaggedEncryptionKeyIdentifierException(field.getName(), fieldTag);
            }
            SecretKey secretKey = (SecretKey)fieldTagToSecretKeyMapping.get(fieldTag);
            SerializedObject serializedClearText = this.wrappedSerializer.serialize(mappedObject.get(fieldKey), String.class);
            byte[] cipherText = encrypter.encrypt(secretKey, (String)serializedClearText.getData());
            mappedObject.put(fieldKey, Base64.getEncoder().encodeToString(cipherText));
        });
        return mappedObject;
    }

    private Map<String, String> buildFieldNamingSerializationStrategyIndependentMapping(Map<String, Object> mappedObject) {
        return mappedObject.keySet().stream().collect(Collectors.toMap(String::toLowerCase, fieldName -> fieldName));
    }

    private Map<String, Object> decryptAnnotatedFields(Map<String, Object> encryptedMappedObject, Map<String, String> serializedFieldNameMapping, List<Field> encryptedFields, Map<String, Optional<SecretKey>> fieldTagToSecretKeyMapping) {
        Decrypter decrypter = this.encrypterDecrypterFactory.createDecrypter();
        encryptedFields.forEach(field -> {
            String fieldTag = field.getAnnotation(EncryptedField.class).tag();
            if (!fieldTagToSecretKeyMapping.containsKey(fieldTag)) {
                throw new MissingTaggedEncryptionKeyIdentifierException(field.getName(), fieldTag);
            }
            String serializedFieldKey = (String)serializedFieldNameMapping.get(field.getName().toLowerCase());
            byte[] cipherText = Base64.getDecoder().decode((String)encryptedMappedObject.get(serializedFieldKey));
            Optional optionalSecretKey = (Optional)fieldTagToSecretKeyMapping.get(fieldTag);
            if (optionalSecretKey.isPresent()) {
                String cleartextSerializedFieldValue = decrypter.decrypt((SecretKey)optionalSecretKey.get(), cipherText);
                Object deserializedFieldValue = this.wrappedSerializer.deserialize((SerializedObject)new SimpleSerializedObject((Object)cleartextSerializedFieldValue, String.class, Object.class.getCanonicalName(), null));
                encryptedMappedObject.put(serializedFieldKey, deserializedFieldValue);
            } else {
                encryptedMappedObject.put(serializedFieldKey, Defaults.defaultValue(field.getType()));
            }
        });
        return encryptedMappedObject;
    }

    private <S> Class<?> getClassToDeserialize(SerializedObject<S> serializedObject) {
        Class<?> classToDeserialize;
        try {
            classToDeserialize = Class.forName(serializedObject.getType().getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return classToDeserialize;
    }
}

