/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.domain.SonosPlayMode;
import engineer.nightowl.sonos.api.domain.SonosPlaylist;
import engineer.nightowl.sonos.api.domain.SonosPlaylistList;
import engineer.nightowl.sonos.api.domain.SonosSuccess;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.SubscribableResource;
import java.util.HashMap;

public class PlaylistResource
extends SubscribableResource {
    public PlaylistResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    @Override
    String getSubscriptionPath() {
        return "/v1/households/%s/playlists/subscription";
    }

    public SonosPlaylistList getPlaylists(String clientToken, String householdId) throws SonosApiClientException, SonosApiError {
        return this.getFromApi(SonosPlaylistList.class, clientToken, String.format("/v1/households/%s/playlists", householdId));
    }

    public SonosPlaylist getPlaylist(String clientToken, String householdId, String playlistId) throws SonosApiClientException, SonosApiError {
        return this.getFromApi(SonosPlaylist.class, clientToken, String.format("/v1/households/%s/playlists/%s", householdId, playlistId));
    }

    public SonosSuccess loadPlaylist(String clientToken, String groupId, String playlistId, Boolean playOnCompletion, SonosPlayMode playMode) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(playlistId, "playlistId");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (playOnCompletion != null) {
            payload.put("playOnCompletion", playOnCompletion);
        }
        if (playMode != null) {
            payload.put("playModes", playMode);
        }
        payload.put("playlistId", playlistId);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playlists", groupId), payload);
    }
}

