/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.domain;

import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.specs.Validatable;
import engineer.nightowl.sonos.api.util.SonosUtilityHelper;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonosSessionRequest
implements Validatable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String accountId;
    private String appContext;
    private String appId;
    private String customData;

    public SonosSessionRequest() {
    }

    public SonosSessionRequest(String accountId, String appContext, String appId, String customData) {
        this.accountId = accountId;
        this.appContext = appContext;
        this.appId = appId;
        this.customData = customData;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public void setAppContext(String appContext) {
        this.appContext = appContext;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getCustomData() {
        return this.customData;
    }

    public void setCustomData(String customData) {
        if (!SonosUtilityHelper.isEmpty(customData) && customData.getBytes().length > 1023 && this.logger.isWarnEnabled()) {
            this.logger.warn("customData is over 1023 bytes - Sonos API will truncate the data");
        }
        this.customData = customData;
    }

    public String toString() {
        return "SonosSessionRequest{accountId='" + this.accountId + '\'' + ", appContext='" + this.appContext + '\'' + ", appId='" + this.appId + '\'' + ", customData='" + this.customData + '\'' + '}';
    }

    @Override
    public void validate() throws SonosApiClientException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.appId == null) {
            validationErrors.add("appId cannot be null when creating/joining a session");
        }
        if (this.appContext == null) {
            validationErrors.add("appContext cannot be null when creating/joining a session");
        }
        if (!validationErrors.isEmpty()) {
            throw new SonosApiClientException(validationErrors);
        }
    }
}

