/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.domain.SonosPlayerVolume;
import engineer.nightowl.sonos.api.domain.SonosSuccess;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.BaseResource;
import engineer.nightowl.sonos.api.specs.Subscribable;
import engineer.nightowl.sonos.api.util.SonosUtilityHelper;
import java.lang.constant.Constable;
import java.util.HashMap;

public class PlayerVolumeResource
extends BaseResource
implements Subscribable {
    public PlayerVolumeResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    public SonosPlayerVolume getVolume(String clientToken, String playerId) throws SonosApiClientException, SonosApiError {
        return this.getFromApi(SonosPlayerVolume.class, clientToken, String.format("/v1/players/%s/playerVolume", playerId));
    }

    public SonosSuccess setMute(String clientToken, String playerId, Boolean isMuted) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(isMuted);
        HashMap<String, Boolean> payload = new HashMap<String, Boolean>();
        payload.put("muted", isMuted);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/players/%s/playerVolume/mute", playerId), payload);
    }

    public SonosSuccess setRelativeVolume(String clientToken, String playerId, Integer volumeDelta, Boolean isMuted) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(volumeDelta);
        HashMap<String, Constable> payload = new HashMap<String, Constable>();
        payload.put("volumeDelta", volumeDelta);
        if (!SonosUtilityHelper.isEmpty(isMuted)) {
            payload.put("muted", isMuted);
        }
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/players/%s/playerVolume/relative", playerId), payload);
    }

    public SonosSuccess setVolume(String clientToken, String playerId, Integer volume, Boolean isMuted) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(volume);
        HashMap<String, Constable> payload = new HashMap<String, Constable>();
        payload.put("volume", volume);
        if (!SonosUtilityHelper.isEmpty(isMuted)) {
            payload.put("muted", isMuted);
        }
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/players/%s/playerVolume", playerId), payload);
    }

    @Override
    public SonosSuccess subscribe(String clientToken, String playerId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/players/%s/playerVolume/subscription", playerId));
    }

    @Override
    public SonosSuccess unsubscribe(String clientToken, String playerId) throws SonosApiClientException, SonosApiError {
        return this.deleteFromApi(SonosSuccess.class, clientToken, String.format("/v1/players/%s/playerVolume/subscription", playerId));
    }
}

