/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class SonosApiConfiguration {
    private String applicationId;
    private String apiKey;
    private String apiSecret;
    private String authBaseUrl;
    private String controlBaseUrl;

    public SonosApiConfiguration() {
        this.loadDefaults();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private String getApiSecret() {
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public String getAuthBaseUrl() {
        return this.authBaseUrl;
    }

    private void setAuthBaseUrl(String authBaseUrl) {
        this.authBaseUrl = authBaseUrl;
    }

    public String getControlBaseUrl() {
        return this.controlBaseUrl;
    }

    private void setControlBaseUrl(String controlBaseUrl) {
        this.controlBaseUrl = controlBaseUrl;
    }

    private void loadDefaults() {
        this.setAuthBaseUrl("api.sonos.com");
        this.setControlBaseUrl("api.ws.sonos.com/control/api");
    }

    public Header getAuthorizationHeader() {
        byte[] authBytes = String.join((CharSequence)":", this.getApiKey(), this.getApiSecret()).getBytes();
        String authBase64 = Base64.encodeBase64String((byte[])authBytes);
        String headerValue = String.join((CharSequence)" ", "Basic", authBase64);
        return new BasicHeader("Authorization", headerValue);
    }
}

