/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.domain.SonosGroupInfo;
import engineer.nightowl.sonos.api.domain.SonosGroups;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.SubscribableResource;
import java.util.HashMap;
import java.util.List;

public class GroupResource
extends SubscribableResource {
    public GroupResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    @Override
    String getSubscriptionPath() {
        return "/v1/households/%s/groups/subscription";
    }

    public SonosGroups getGroups(String clientToken, String householdId) throws SonosApiClientException, SonosApiError {
        return this.getFromApi(SonosGroups.class, clientToken, String.format("/v1/households/%s/groups", householdId));
    }

    public SonosGroupInfo createGroup(String clientToken, String householdId, List<String> playerIds, String musicContextGroupId) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(playerIds);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (musicContextGroupId != null) {
            payload.put("musicContextGroupId", musicContextGroupId);
        }
        payload.put("playerIds", playerIds);
        return this.postToApi(SonosGroupInfo.class, clientToken, String.format("/v1/households/%s/groups/createGroup", householdId), payload);
    }

    public SonosGroupInfo modifyGroupMembers(String clientToken, String groupId, List<String> playerIdsToAdd, List<String> playerIdsToRemove) throws SonosApiClientException, SonosApiError {
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        if (playerIdsToAdd != null && !playerIdsToAdd.isEmpty()) {
            payload.put("playerIdsToAdd", playerIdsToAdd);
        }
        if (playerIdsToRemove != null && !playerIdsToRemove.isEmpty()) {
            payload.put("playerIdsToRemove", playerIdsToRemove);
        }
        return this.postToApi(SonosGroupInfo.class, clientToken, String.format("/v1/groups/%s/groups/modifyGroupMembers", groupId), payload);
    }

    public SonosGroupInfo setGroupMembers(String clientToken, String groupId, List<String> playerIds) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(playerIds);
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        payload.put("playerIds", playerIds);
        return this.postToApi(SonosGroupInfo.class, clientToken, String.format("/v1/groups/%s/groups/setGroupMembers", groupId), payload);
    }
}

