/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.util;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonosCallbackHelper {
    private static final Logger logger = LoggerFactory.getLogger(SonosCallbackHelper.class);

    public static Boolean verifySignature(Map<String, String> headers, String apiKey, String apiSecret) throws SonosApiClientException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SonosApiClientException("Unsupported execution environment", e);
        }
        messageDigest.update(headers.get("X-Sonos-Event-Seq-Id").getBytes(StandardCharsets.UTF_8));
        messageDigest.update(headers.get("X-Sonos-Namespace").getBytes(StandardCharsets.UTF_8));
        messageDigest.update(headers.get("X-Sonos-Type").getBytes(StandardCharsets.UTF_8));
        messageDigest.update(headers.get("X-Sonos-Target-Type").getBytes(StandardCharsets.UTF_8));
        messageDigest.update(headers.get("X-Sonos-Target-Value").getBytes(StandardCharsets.UTF_8));
        messageDigest.update(apiKey.getBytes(StandardCharsets.UTF_8));
        messageDigest.update(apiSecret.getBytes(StandardCharsets.UTF_8));
        String signature = Base64.getUrlEncoder().withoutPadding().encodeToString(messageDigest.digest());
        logger.debug("Verifying signature: {}", (Object)signature);
        return signature.equals(headers.get("X-Sonos-Event-Signature"));
    }

    public static Boolean verifySignature(Map<String, String> headers, SonosApiClient apiClient) throws SonosApiClientException {
        return SonosCallbackHelper.verifySignature(headers, apiClient.getConfiguration().getApiKey(), apiClient.getConfiguration().getApiSecret());
    }

    public static Boolean verifySignature(HttpMessage message, SonosApiClient apiClient) throws SonosApiClientException {
        return SonosCallbackHelper.verifySignature(message, apiClient.getConfiguration().getApiKey(), apiClient.getConfiguration().getApiSecret());
    }

    public static Boolean verifySignature(HttpMessage message, String apiKey, String apiSecret) throws SonosApiClientException {
        Map<String, String> headers = SonosCallbackHelper.convertHeadersToMap(message.getAllHeaders());
        return SonosCallbackHelper.verifySignature(headers, apiKey, apiSecret);
    }

    public static Map<String, String> convertHeadersToMap(Header[] headers) {
        return Arrays.stream(headers).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
    }
}

