/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.domain.SonosCloudQueueRequest;
import engineer.nightowl.sonos.api.domain.SonosPlaybackSessionStatus;
import engineer.nightowl.sonos.api.domain.SonosSessionRequest;
import engineer.nightowl.sonos.api.domain.SonosStreamUrlRequest;
import engineer.nightowl.sonos.api.domain.SonosSuccess;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.SubscribableResource;
import engineer.nightowl.sonos.api.util.SonosUtilityHelper;
import java.util.HashMap;

public class PlaybackSessionResource
extends SubscribableResource {
    public PlaybackSessionResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    @Override
    String getSubscriptionPath() {
        return "/v1/playbackSessions/%s/playbackSession/subscription";
    }

    public SonosPlaybackSessionStatus createSession(String clientToken, String groupId, SonosSessionRequest request) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosPlaybackSessionStatus.class, clientToken, String.format("/v1/groups/%s/playbackSession", groupId), request);
    }

    public SonosPlaybackSessionStatus joinSession(String clientToken, String groupId, SonosSessionRequest request) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosPlaybackSessionStatus.class, clientToken, String.format("/v1/groups/%s/playbackSession/join", groupId), request);
    }

    public SonosPlaybackSessionStatus joinOrCreateSession(String clientToken, String groupId, SonosSessionRequest request) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosPlaybackSessionStatus.class, clientToken, String.format("/v1/groups/%s/playbackSession/joinOrCreate", groupId), request);
    }

    public SonosSuccess loadCloudQueue(String clientToken, String sessionId, SonosCloudQueueRequest request) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/playbackSessions/%s/playbackSession/loadCloudQueue", sessionId), request);
    }

    public SonosSuccess loadStreamUrl(String clientToken, String sessionId, SonosStreamUrlRequest request) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/playbackSessions/%s/playbackSession/loadStreamUrl", sessionId), request);
    }

    public SonosSuccess refreshCloudQueue(String clientToken, String sessionId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/playbackSessions/%s/playbackSession/refreshCloudQueue", sessionId));
    }

    public SonosSuccess skipToItem(String clientToken, String sessionId, SonosSessionRequest request) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/playbackSessions/%s/playbackSession/skipToItem", sessionId), request);
    }

    public SonosSuccess seek(String clientToken, String sessionId, String itemId, String positionMillis) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(itemId);
        this.validateNotNull(positionMillis);
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("itemId", itemId);
        payload.put("positionMillis", positionMillis);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/playbackSessions/%s/playbackSession/seek", sessionId), payload);
    }

    public SonosSuccess seekRelative(String clientToken, String sessionId, String itemId, String deltaMillis) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(itemId);
        this.validateNotNull(deltaMillis);
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("itemId", itemId);
        payload.put("deltaMillis", deltaMillis);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/playbackSessions/%s/playbackSession/seekRelative", sessionId), payload);
    }

    public SonosSuccess suspend(String clientToken, String sessionId, String queueVersion) throws SonosApiClientException, SonosApiError {
        HashMap<String, String> payload = new HashMap<String, String>();
        if (!SonosUtilityHelper.isEmpty(queueVersion)) {
            payload.put("queueVersion", queueVersion);
        }
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/playbackSessions/%s/playbackSession/suspend", sessionId), payload);
    }
}

