/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.domain.SonosGroupInfo;
import engineer.nightowl.sonos.api.domain.SonosGroups;
import engineer.nightowl.sonos.api.domain.SonosSuccess;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.BaseResource;
import engineer.nightowl.sonos.api.specs.Subscribable;
import java.util.HashMap;
import java.util.List;

public class GroupResource
extends BaseResource
implements Subscribable {
    public GroupResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    public SonosGroups getGroups(String clientToken, String householdId) throws SonosApiClientException, SonosApiError {
        return this.getFromApi(SonosGroups.class, clientToken, String.format("/v1/households/%s/groups", householdId));
    }

    public SonosGroupInfo createGroup(String clientToken, String householdId, List<String> playerIds, String musicContextGroupId) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(playerIds);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (musicContextGroupId != null) {
            payload.put("musicContextGroupId", musicContextGroupId);
        }
        payload.put("playerIds", playerIds);
        return this.postToApi(SonosGroupInfo.class, clientToken, String.format("/v1/households/%s/groups/createGroup", householdId), payload);
    }

    public SonosGroupInfo modifyGroupMembers(String clientToken, String groupId, List<String> playerIdsToAdd, List<String> playerIdsToRemove) throws SonosApiClientException, SonosApiError {
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        if (playerIdsToAdd != null && playerIdsToAdd.size() > 0) {
            payload.put("playerIdsToAdd", playerIdsToAdd);
        }
        if (playerIdsToRemove != null && playerIdsToRemove.size() > 0) {
            payload.put("playerIdsToRemove", playerIdsToRemove);
        }
        return this.postToApi(SonosGroupInfo.class, clientToken, String.format("/v1/groups/%s/modifyGroupMembers", groupId), payload);
    }

    public SonosGroupInfo setGroupMembers(String clientToken, String groupId, List<String> playerIds) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(playerIds);
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        payload.put("playerIds", playerIds);
        return this.postToApi(SonosGroupInfo.class, clientToken, String.format("/v1/groups/%s/setGroupMembers", groupId), payload);
    }

    @Override
    public SonosSuccess subscribe(String clientToken, String householdId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/households/%s/groups/subscription", householdId));
    }

    @Override
    public SonosSuccess unsubscribe(String clientToken, String householdId) throws SonosApiClientException, SonosApiError {
        return this.deleteFromApi(SonosSuccess.class, clientToken, String.format("/v1/households/%s/groups/subscription", householdId));
    }
}

