/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.domain.SonosFavoriteList;
import engineer.nightowl.sonos.api.domain.SonosPlayMode;
import engineer.nightowl.sonos.api.domain.SonosSuccess;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.BaseResource;
import engineer.nightowl.sonos.api.specs.Subscribable;
import java.util.HashMap;

public class FavoriteResource
extends BaseResource
implements Subscribable {
    public FavoriteResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    public SonosFavoriteList getFavorites(String clientToken, String householdId) throws SonosApiClientException, SonosApiError {
        return this.getFromApi(SonosFavoriteList.class, clientToken, String.format("/v1/households/%s/favorites", householdId));
    }

    public SonosSuccess loadFavorite(String clientToken, String groupId, String favoriteId, Boolean playOnCompletion, SonosPlayMode playMode) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(favoriteId, "favoriteId");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (playOnCompletion != null) {
            payload.put("playOnCompletion", playOnCompletion);
        }
        if (playMode != null) {
            payload.put("playModes", playMode);
        }
        payload.put("favoriteId", favoriteId);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/favorites", groupId), payload);
    }

    @Override
    public SonosSuccess subscribe(String clientToken, String householdId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/households/%s/favorites/subscription", householdId));
    }

    @Override
    public SonosSuccess unsubscribe(String clientToken, String householdId) throws SonosApiClientException, SonosApiError {
        return this.deleteFromApi(SonosSuccess.class, clientToken, String.format("/v1/households/%s/favorites/subscription", householdId));
    }
}

