/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.groupsio.api.resource;

import engineer.nightowl.groupsio.api.GroupsIOApiClient;
import engineer.nightowl.groupsio.api.domain.Page;
import engineer.nightowl.groupsio.api.domain.Subscription;
import engineer.nightowl.groupsio.api.domain.User;
import engineer.nightowl.groupsio.api.exception.GroupsIOApiException;
import engineer.nightowl.groupsio.api.resource.BaseResource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class UserResource
extends BaseResource {
    public UserResource(GroupsIOApiClient apiClient, String baseUrl) {
        super(apiClient, baseUrl);
    }

    public User getUser() throws URISyntaxException, IOException, GroupsIOApiException {
        URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "getuser");
        HttpGet request = new HttpGet();
        request.setURI(uri.build());
        return this.callApi((HttpUriRequest)request, User.class);
    }

    public Subscription getSubscription(Integer groupId) throws URISyntaxException, IOException, GroupsIOApiException {
        URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "getsub");
        uri.setParameter("group_id", groupId.toString());
        HttpGet request = new HttpGet();
        request.setURI(uri.build());
        return this.callApi((HttpUriRequest)request, Subscription.class);
    }

    public List<Subscription> getSubscriptions() throws URISyntaxException, IOException, GroupsIOApiException {
        URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "getsubs");
        uri.setParameter("limit", "100");
        HttpGet request = new HttpGet();
        request.setURI(uri.build());
        Page page = this.callApi((HttpUriRequest)request, Page.class);
        List<Object> subscriptions = Arrays.asList((Object[])OM.convertValue(page.getData(), Subscription[].class));
        while (page.getHasMore().booleanValue()) {
            uri.setParameter("page_token", page.getNextPageToken().toString());
            request.setURI(uri.build());
            page = this.callApi((HttpUriRequest)request, Page.class);
            subscriptions.addAll(Arrays.asList((Object[])OM.convertValue(page.getData(), Subscription[].class)));
        }
        return subscriptions;
    }

    public User updateUser(User user) throws URISyntaxException, IOException, GroupsIOApiException {
        URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "updateuser");
        HttpPost request = new HttpPost();
        Map map = (Map)OM.convertValue((Object)user, Map.class);
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        for (Map.Entry entry : map.entrySet()) {
            postParameters.add(new BasicNameValuePair((String)entry.getKey(), entry.getValue().toString()));
        }
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
        request.setURI(uri.build());
        return this.callApi((HttpUriRequest)request, User.class);
    }

    public Subscription updateSubscription(Subscription subscription) {
        throw new UnsupportedOperationException("Not available in API");
    }

    public void deleteSubscription(Subscription subscription) {
        throw new UnsupportedOperationException("Not available in API");
    }

    public void joinGroup(Integer groupId) {
        throw new UnsupportedOperationException("Not available in API");
    }
}

