/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.groupsio.api.resource;

import engineer.nightowl.groupsio.api.GroupsIOApiClient;
import engineer.nightowl.groupsio.api.domain.DirectAdd;
import engineer.nightowl.groupsio.api.domain.Error;
import engineer.nightowl.groupsio.api.domain.Page;
import engineer.nightowl.groupsio.api.domain.Subscription;
import engineer.nightowl.groupsio.api.exception.GroupsIOApiException;
import engineer.nightowl.groupsio.api.exception.GroupsIOApiExceptionType;
import engineer.nightowl.groupsio.api.resource.BaseResource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class MemberResource
extends BaseResource {
    public MemberResource(GroupsIOApiClient apiClient, String baseUrl) {
        super(apiClient, baseUrl);
    }

    public Subscription getMemberInGroup(Integer groupId, Integer memberId) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getViewMembers().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "getmember");
            uri.setParameter("group_id", groupId.toString());
            uri.setParameter("sub_id", memberId.toString());
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Subscription.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public List<Subscription> getMembersInGroup(Integer groupId) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getViewMembers().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "getmembers");
            uri.setParameter("group_id", groupId.toString());
            uri.setParameter("limit", "100");
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            Page page = this.callApi((HttpUriRequest)request, Page.class);
            List<Object> subscriptions = Arrays.asList((Object[])OM.convertValue(page.getData(), Subscription[].class));
            while (page.getHasMore().booleanValue()) {
                uri.setParameter("page_token", page.getNextPageToken().toString());
                request.setURI(uri.build());
                page = this.callApi((HttpUriRequest)request, Page.class);
                subscriptions.addAll(Arrays.asList((Object[])OM.convertValue(page.getData(), Subscription[].class)));
            }
            return subscriptions;
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public List<Subscription> searchMembers(Integer groupId, String query) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getViewMembers().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "searchmembers");
            uri.setParameter("group_id", groupId.toString());
            uri.setParameter("q", query);
            uri.setParameter("limit", "100");
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            Page page = this.callApi((HttpUriRequest)request, Page.class);
            List<Object> subscriptions = Arrays.asList((Object[])OM.convertValue(page.getData(), Subscription[].class));
            while (page.getHasMore().booleanValue()) {
                uri.setParameter("page_token", page.getNextPageToken().toString());
                request.setURI(uri.build());
                page = this.callApi((HttpUriRequest)request, Page.class);
                subscriptions.addAll(Arrays.asList((Object[])OM.convertValue(page.getData(), Subscription[].class)));
            }
            return subscriptions;
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public Subscription updateMember(Subscription subscription) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(subscription.getGroupId()).getManageMemberSubscriptionOptions().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "updatemember");
            HttpPost request = new HttpPost();
            Map map = (Map)OM.convertValue((Object)subscription, Map.class);
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            for (Map.Entry entry : map.entrySet()) {
                postParameters.add(new BasicNameValuePair((String)entry.getKey(), entry.getValue().toString()));
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Subscription.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public Subscription banMember(Integer groupId, Integer subscriptionId) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getBanMembers().booleanValue() && this.getMemberInGroup(groupId, subscriptionId).getStatus().canBan().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "banmember");
            uri.setParameter("group_id", groupId.toString());
            uri.setParameter("sub_id", subscriptionId.toString());
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Subscription.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public Subscription approveMember(Integer groupId, Integer subscriptionId) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getManagePendingMembers().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "approvemember");
            uri.setParameter("group_id", groupId.toString());
            uri.setParameter("sub_id", subscriptionId.toString());
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Subscription.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public void directAddMember(Integer groupId, List<String> emails) throws URISyntaxException, IOException, GroupsIOApiException {
        if (!this.apiClient.group().getPermissions(groupId).getInviteMembers().booleanValue()) {
            Error error = new Error();
            error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
            throw new GroupsIOApiException(error);
        }
        URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "directadd");
        uri.setParameter("group_id", groupId.toString());
        uri.setParameter("emails", String.join((CharSequence)"\n", emails));
        HttpGet request = new HttpGet();
        request.setURI(uri.build());
        this.callApi((HttpUriRequest)request, DirectAdd.class);
    }

    public void inviteMember() {
        throw new NotImplementedException("Not implemented in client");
    }

    public Subscription removeMember(Integer groupId, Integer subscriptionId) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getRemoveMembers().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "removemember");
            uri.setParameter("group_id", groupId.toString());
            uri.setParameter("sub_id", subscriptionId.toString());
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Subscription.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public Subscription sendBounceProbe(Integer groupId, Integer subscriptionId) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getManageMemberSubscriptionOptions().booleanValue() && this.getMemberInGroup(groupId, subscriptionId).getUserStatus().canSendBounceProbe().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "sendbounceprobe");
            uri.setParameter("group_id", groupId.toString());
            uri.setParameter("sub_id", subscriptionId.toString());
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Subscription.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public Subscription sendConfirmationEmail(Integer groupId, Integer subscriptionId) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getManageMemberSubscriptionOptions().booleanValue() && this.getMemberInGroup(groupId, subscriptionId).getUserStatus().canSendConfirmationEmail().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "sendconfirmation");
            uri.setParameter("group_id", groupId.toString());
            uri.setParameter("sub_id", subscriptionId.toString());
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Subscription.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }
}

