/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.dwheaderbundle.internals;

import engineer.nightowl.dwheaderbundle.HeaderAuthConfiguration;
import engineer.nightowl.dwheaderbundle.internals.HeaderAuthenticator;
import engineer.nightowl.dwheaderbundle.internals.HeaderCredentials;
import engineer.nightowl.dwheaderbundle.internals.HeaderSecurityContext;
import engineer.nightowl.dwheaderbundle.internals.PrincipalService;
import io.dropwizard.auth.AuthFilter;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@PreMatching
@Priority(value=1000)
public class HeaderAuthenticationFilter<P extends Principal, S extends PrincipalService<P>>
extends AuthFilter<HeaderCredentials, P> {
    private HeaderAuthenticator<P, S> authenticator;
    private HeaderAuthConfiguration configuration;
    private S principalService;

    public HeaderAuthenticationFilter(HeaderAuthenticator<P, S> authenticator, HeaderAuthConfiguration configuration, S principalService) {
        this.authenticator = authenticator;
        this.configuration = configuration;
        this.principalService = principalService;
    }

    public void filter(ContainerRequestContext requestContext) {
        HeaderCredentials credentials = this.getCredentials(requestContext);
        Optional<P> authenticatedPrincipal = this.authenticator.authenticate(credentials);
        if (!authenticatedPrincipal.isPresent()) {
            throw new WebApplicationException("Principal not found", Response.Status.UNAUTHORIZED);
        }
        Principal principal = (Principal)authenticatedPrincipal.get();
        List<String> principalRoles = ((PrincipalService)this.principalService).getPrincipalRoles((Principal)principal);
        SecurityContext requestSecurityContext = requestContext.getSecurityContext();
        HeaderSecurityContext<Principal> securityContext = new HeaderSecurityContext<Principal>(principal, principalRoles, requestSecurityContext);
        requestContext.setSecurityContext(securityContext);
    }

    private HeaderCredentials getCredentials(ContainerRequestContext requestContext) {
        return new HeaderCredentials(requestContext.getHeaderString(this.configuration.getHeaderName()));
    }
}

