/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.dwheaderbundle;

import engineer.nightowl.dwheaderbundle.HeaderAuthConfiguration;
import engineer.nightowl.dwheaderbundle.internals.HeaderAuthBundleConfiguration;
import engineer.nightowl.dwheaderbundle.internals.HeaderAuthenticationFilter;
import engineer.nightowl.dwheaderbundle.internals.HeaderAuthenticator;
import engineer.nightowl.dwheaderbundle.internals.PrincipalService;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.security.Principal;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;

public class HeaderAuthBundle<P extends Principal, S extends PrincipalService<P>>
implements ConfiguredBundle<HeaderAuthBundleConfiguration> {
    private final Class<P> principalClass;
    private final S principalService;

    public HeaderAuthBundle(Class<P> principalClass, S principalService) {
        this.principalClass = principalClass;
        this.principalService = principalService;
    }

    public void run(HeaderAuthBundleConfiguration headerAuthBundleConfiguration, Environment environment) {
        HeaderAuthConfiguration configuration = headerAuthBundleConfiguration.getHeaderAuthConfiguration();
        HeaderAuthenticator headerAuthenticator = new HeaderAuthenticator(this.principalService);
        HeaderAuthenticationFilter headerAuthenticationFilter = new HeaderAuthenticationFilter(headerAuthenticator, configuration, this.principalService);
        environment.jersey().register((Object)new AuthDynamicFeature(headerAuthenticationFilter));
        environment.jersey().register((Object)new AuthValueFactoryProvider.Binder(this.principalClass));
        environment.jersey().register(RolesAllowedDynamicFeature.class);
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }
}

