/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.dwheaderbundle.internals;

import java.security.Principal;
import java.util.List;
import javax.ws.rs.core.SecurityContext;

public class HeaderSecurityContext<P extends Principal>
implements SecurityContext {
    private final P principal;
    private final List<String> groups;
    private final SecurityContext securityContext;

    public HeaderSecurityContext(P principal, List<String> groups, SecurityContext securityContext) {
        this.principal = principal;
        this.groups = groups;
        this.securityContext = securityContext;
    }

    public P getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return this.groups.contains(role);
    }

    public boolean isSecure() {
        return this.securityContext.isSecure();
    }

    public String getAuthenticationScheme() {
        return "HEADER_AUTH";
    }
}

