/*
 * Decompiled with CFR 0.152.
 */
package engineer.echo.easyapi.compiler;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.sun.tools.javac.code.Symbol;
import engineer.echo.easyapi.annotation.EasyJobHelper;
import engineer.echo.easyapi.annotation.JobCallback;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class CompilerHelper {
    CompilerHelper() {
    }

    static boolean createMetaInfoFile(Filer filer, String appId, String uniqueId, String className) {
        FieldSpec fieldAppId = FieldSpec.builder(String.class, (String)"APP_ID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{appId}).build();
        FieldSpec metaInfo = FieldSpec.builder(String.class, (String)"metaInfo", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).initializer("$S", new Object[]{className}).build();
        FieldSpec fieldId = FieldSpec.builder(String.class, (String)"uniqueId", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).initializer("$S", new Object[]{uniqueId}).build();
        TypeSpec classType = TypeSpec.classBuilder((String)"MetaInfo").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(metaInfo).addField(fieldAppId).addField(fieldId).build();
        JavaFile javaFile = JavaFile.builder((String)EasyJobHelper.generatePackage((String)uniqueId), (TypeSpec)classType).addFileComment("This codes are generated by EasyApi automatically. Do not modify!", new Object[0]).build();
        try {
            javaFile.writeTo(filer);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static String createRetrofitApi(Filer filer, TypeElement interfaceElement) {
        try {
            String className = interfaceElement.getQualifiedName().toString();
            String simpleName = interfaceElement.getSimpleName().toString();
            String packageName = className.replace("." + simpleName, "");
            TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)(simpleName + "Retrofit")).addModifiers(new Modifier[]{Modifier.PUBLIC});
            List<? extends Element> elements = interfaceElement.getEnclosedElements();
            for (Element element : elements) {
                if (element.getKind() != ElementKind.METHOD || !(element instanceof Symbol.MethodSymbol)) continue;
                String methodName = element.getSimpleName().toString();
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)element;
                AnnotationSpec specGet = AnnotationSpec.builder((ClassName)ClassName.get((String)"retrofit2.http", (String)"GET", (String[])new String[0])).addMember("value", "$S", new Object[]{EasyJobHelper.generateRetrofitPath((String)className, (String)methodName)}).build();
                ClassName liveDataClass = ClassName.get((String)"androidx.lifecycle", (String)"LiveData", (String[])new String[0]);
                TypeName returnClass = TypeName.get((TypeMirror)methodSymbol.getReturnType());
                ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)liveDataClass, (TypeName[])new TypeName[]{returnClass});
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(methodSymbol.getModifiers()).addAnnotation(specGet).returns((TypeName)returnType);
                List varSymbols = methodSymbol.getParameters();
                AnnotationSpec.Builder specHeader = AnnotationSpec.builder((ClassName)ClassName.get((String)"retrofit2.http", (String)"Headers", (String[])new String[0]));
                int paramSize = varSymbols.size();
                for (int i = 0; i < paramSize; ++i) {
                    Symbol.VarSymbol var = (Symbol.VarSymbol)varSymbols.get(i);
                    String queryName = var.name.toString();
                    AnnotationSpec specQuery = AnnotationSpec.builder((ClassName)ClassName.get((String)"retrofit2.http", (String)"Query", (String[])new String[0])).addMember("value", "$S", new Object[]{queryName}).build();
                    TypeName queryType = TypeName.get((TypeMirror)var.type);
                    String queryTypeStr = queryType.toString();
                    boolean isJobCallback = queryTypeStr.equals(JobCallback.class.getName());
                    if (isJobCallback && i != paramSize - 1) {
                        return "EasyApi\uff1arequire one JobCallback at most and put it at last position.";
                    }
                    if (!isJobCallback) {
                        methodBuilder.addParameter(ParameterSpec.builder((TypeName)queryType, (String)queryName, (Modifier[])new Modifier[0]).addAnnotation(specQuery).build());
                    }
                    specHeader.addMember("value", "$L", new Object[]{CodeBlock.builder().add("$S", new Object[]{queryName + ":" + queryTypeStr}).build()});
                }
                methodBuilder.addAnnotation(specHeader.build());
                interfaceBuilder.addMethod(methodBuilder.build());
            }
            TypeSpec interfaceType = interfaceBuilder.build();
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)interfaceType).addFileComment("This codes are generated by EasyApi automatically. Do not modify!", new Object[0]).build();
            try {
                javaFile.writeTo(filer);
                return null;
            }
            catch (IOException e) {
                return "EasyApi writeFailed " + e.getMessage();
            }
        }
        catch (Exception e) {
            return "EasyApi classFailed " + e.toString();
        }
    }
}

