/*
 * Decompiled with CFR 0.152.
 */
package engineer.echo.easyapi.annotation;

import engineer.echo.easyapi.annotation.MD5Tool;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;

public final class EasyJobHelper {
    private static final String PACKAGE = "engineer.echo.easyapi.compiler";
    public static final String CLASS = "MetaInfo";
    public static final String EASY_JOB_API = "_api_";
    public static final String EASY_JOB_METHOD = "_method_";
    private static final String JOB_API_URL = "EasyApi/EasyProxy/?_api_=";

    public static boolean isEasyJobRequest(String url) {
        return url != null && url.length() > 0 && url.contains(JOB_API_URL);
    }

    public static String generateRetrofitPath(String api, String method) {
        return JOB_API_URL + api + "&" + EASY_JOB_METHOD + "=" + method;
    }

    public static String generatePackage(String id) {
        return "engineer.echo.easyapi.compiler.meta" + MD5Tool.getMD5(id);
    }

    public static Class<?> transformToClass(String className) throws ClassNotFoundException {
        if (className == null || className.length() == 0) {
            throw new InvalidParameterException("invalid class");
        }
        switch (className) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return Class.forName(className);
    }

    private static String getClassById(String id) {
        try {
            Class<?> clz = Class.forName(EasyJobHelper.generatePackage(id) + "." + CLASS);
            Field field = clz.getField("metaInfo");
            Object result = field.get(null);
            if (result instanceof String) {
                return (String)result;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getObjectById(String id) {
        String className = EasyJobHelper.getClassById(id);
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            Class<?> clz = Class.forName(className);
            return clz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

