/*
 * Decompiled with CFR 0.152.
 */
package earth.levi.dotenv.util;

import earth.levi.dotenv.util.CliUtil;
import earth.levi.dotenv.util.CliUtilKt;
import earth.levi.dotenv.util.Log;
import earth.levi.dotenv.util.LogKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Learth/levi/dotenv/util/CliUtil;", "", "()V", "CLI_DOWNLOAD_LINUX_64", "", "CLI_DOWNLOAD_LINUX_arm64", "CLI_DOWNLOAD_LINUX_i386", "CLI_DOWNLOAD_MAC_64", "doesCliExist", "", "project", "Lorg/gradle/api/Project;", "downloadCliBin", "", "downloadFile", "url", "path", "getCliVersion", "isCliVersionCompatible", "dotenv"})
public final class CliUtil {
    private static final String CLI_DOWNLOAD_MAC_64 = "https://github.com/levibostian/dotenv/releases/download/{version}/dotenv_{version}_Darwin_x86_64.tar.gz";
    private static final String CLI_DOWNLOAD_LINUX_arm64 = "https://github.com/levibostian/dotenv/releases/download/{version}/dotenv_{version}_Linux_arm64.tar.gz";
    private static final String CLI_DOWNLOAD_LINUX_i386 = "https://github.com/levibostian/dotenv/releases/download/{version}/dotenv_{version}_Linux_i386.tar.gz";
    private static final String CLI_DOWNLOAD_LINUX_64 = "https://github.com/levibostian/dotenv/releases/download/{version}/dotenv_{version}_Linux_x86_64.tar.gz";
    public static final CliUtil INSTANCE;

    public final boolean doesCliExist(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getCliVersion(project) != null;
    }

    public final boolean isCliVersionCompatible(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!this.doesCliExist(project)) {
            return false;
        }
        Function1 getCompareString2 = isCliVersionCompatible.getCompareString.1.INSTANCE;
        String string = this.getCliVersion(project);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String cliVersionInstalled = string;
        Log.INSTANCE.debug(project, "---Asserting CLI version compatible.");
        Log.INSTANCE.debug(project, "Installed CLI version: " + cliVersionInstalled);
        int currentInstalledVersionCompareString = ((Number)getCompareString2.invoke((Object)cliVersionInstalled)).intValue();
        int minVersionInstalled = ((Number)getCompareString2.invoke((Object)"1.1.0")).intValue();
        int maxVersionInstalled = ((Number)getCompareString2.invoke((Object)"2.0.0")).intValue();
        Log.INSTANCE.debug(project, "Version values to compare. Current installed: " + currentInstalledVersionCompareString + ", min: " + minVersionInstalled + ", max: " + maxVersionInstalled);
        return currentInstalledVersionCompareString >= minVersionInstalled && currentInstalledVersionCompareString < maxVersionInstalled;
    }

    private final String getCliVersion(Project project) {
        String string;
        LogKt.logDebug(project, "Getting CLI version....");
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            project.exec((Action)new Action<ExecSpec>(byteOutputStream, project){
                final /* synthetic */ ByteArrayOutputStream $byteOutputStream;
                final /* synthetic */ Project $project;

                public final void execute(ExecSpec it) {
                    ExecSpec execSpec = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"it");
                    execSpec.setStandardOutput((OutputStream)this.$byteOutputStream);
                    it.setIgnoreExitValue(false);
                    it.setExecutable(CliUtilKt.dotenvCliBinPath(this.$project));
                    it.setArgs(CollectionsKt.listOf((Object)"version"));
                }
                {
                    this.$byteOutputStream = byteArrayOutputStream;
                    this.$project = project;
                }
            }).assertNormalExitValue();
            String string2 = byteOutputStream.toString("UTF-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"byteOutputStream.toString(\"UTF-8\")");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String cliVersion = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            LogKt.logDebug(project, "CLI version does exist: " + cliVersion);
            string = cliVersion;
        }
        catch (Exception error) {
            LogKt.logDebug(project, "Could not get CLI version. Must not be installed.");
            string = null;
        }
        return string;
    }

    public final void downloadCliBin(@NotNull Project project) {
        String downloadPath;
        String baseDownloadUrl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String osName = string4;
        boolean isWindows = StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null);
        boolean isMac = StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null);
        boolean isLinux = !isWindows && !isMac;
        String cpuType = System.getProperty("os.arch");
        boolean is64BitCpu = Intrinsics.areEqual((Object)cpuType, (Object)"x86_64") || Intrinsics.areEqual((Object)cpuType, (Object)"amd64");
        boolean is32BitCpu = Intrinsics.areEqual((Object)cpuType, (Object)"x86") || Intrinsics.areEqual((Object)cpuType, (Object)"386") || Intrinsics.areEqual((Object)cpuType, (Object)"i386");
        boolean isArm64Cpu = Intrinsics.areEqual((Object)cpuType, (Object)"arm64");
        File file = project.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        String downloadBinaryPath = FilesKt.resolve((File)file, (String)"dotenv").getAbsolutePath();
        LogKt.logInfo(project, "--Downloading binary for local execution. ");
        LogKt.logDebug(project, "downloading to absolute path: " + downloadBinaryPath);
        Function0 getUnsupportedBinaryException2 = (Function0)new Function0<RuntimeException>(osName, cpuType){
            final /* synthetic */ String $osName;
            final /* synthetic */ String $cpuType;

            @NotNull
            public final RuntimeException invoke() {
                return new RuntimeException("It looks like the Gradle plugin does not support your computer. Please, file an issue: https://github.com/levibostian/dotenv-android/issues/new with the full stacktrace. OS name: " + this.$osName + ", Arch: " + this.$cpuType);
            }
            {
                this.$osName = string;
                this.$cpuType = string2;
                super(0);
            }
        };
        if (isWindows) {
            LogKt.logDebug(project, "Detected OS: Windows");
            String string5 = "It appears you are using Windows as your operating system. Sorry, but at this time dotenv-android requires that you manually install a dependency in order to use this Gradle plugin.";
            boolean bl2 = false;
            System.out.println((Object)string5);
            throw (Throwable)new RuntimeException("Follow the install instructions: https://github.com/levibostian/dotenv#install and try running the plugin again.");
        }
        if (isMac) {
            LogKt.logDebug(project, "Detected OS: Mac");
            String string6 = is64BitCpu ? CLI_DOWNLOAD_MAC_64 : null;
            if (string6 == null) {
                throw (Throwable)getUnsupportedBinaryException2.invoke();
            }
            baseDownloadUrl = string6;
            downloadPath = StringsKt.replace$default((String)baseDownloadUrl, (String)"{version}", (String)"1.1.0", (boolean)false, (int)4, null);
            LogKt.logDebug(project, "binary download URL: " + downloadPath);
            String string7 = downloadBinaryPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"downloadBinaryPath");
            this.downloadFile(downloadPath, string7);
        }
        if (isLinux) {
            LogKt.logDebug(project, "Detected OS: Linux");
            String string8 = is64BitCpu ? CLI_DOWNLOAD_LINUX_64 : (is32BitCpu ? CLI_DOWNLOAD_LINUX_i386 : (isArm64Cpu ? CLI_DOWNLOAD_LINUX_arm64 : null));
            if (string8 == null) {
                throw (Throwable)getUnsupportedBinaryException2.invoke();
            }
            baseDownloadUrl = string8;
            downloadPath = StringsKt.replace$default((String)baseDownloadUrl, (String)"{version}", (String)"1.1.0", (boolean)false, (int)4, null);
            LogKt.logDebug(project, "binary download URL: " + downloadPath);
            String string9 = downloadBinaryPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"downloadBinaryPath");
            this.downloadFile(downloadPath, string9);
        }
        LogKt.logDebug(project, "binary downloaded successfully");
        File localCliFile = new File(CliUtilKt.dotenvCliLocalBinPath(project));
        if (!localCliFile.exists()) {
            throw (Throwable)new RuntimeException("There is a bug with the gradle plugin. Please, file an issue https://github.com/levibostian/dotenv-android/issues/new with this full stacktrace.");
        }
        Files.setPosixFilePermissions(localCliFile.toPath(), PosixFilePermissions.fromString("rwxr-x--x"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void downloadFile(String url, String path) {
        BufferedInputStream inputStream = new BufferedInputStream(new URL(url).openStream());
        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)inputStream));
        TarArchiveEntry entry = null;
        while (tarIn.getNextTarEntry() != null) {
            TarArchiveEntry tarArchiveEntry;
            boolean bl = false;
            boolean bl2 = false;
            TarArchiveEntry it = tarArchiveEntry;
            boolean bl3 = false;
            entry = it;
            TarArchiveEntry tarArchiveEntry2 = tarArchiveEntry;
            if (tarArchiveEntry2 == null) return;
            TarArchiveEntry tarArchiveEntry3 = entry;
            if (tarArchiveEntry3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"entry");
            }
            if (tarArchiveEntry3.isDirectory()) {
                File file = new File(path);
                String string = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                File file2 = FilesKt.resolve((File)file, (String)string);
                if (file2.mkdirs()) continue;
                throw (Throwable)new RuntimeException("Unable to create directory " + file2.getAbsolutePath());
            }
            Ref.IntRef count = new Ref.IntRef();
            byte[] data = new byte[8192];
            File file = new File(path);
            String string = entry.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
            FileOutputStream fos = new FileOutputStream(FilesKt.resolve((File)file, (String)string), false);
            Closeable closeable = new BufferedOutputStream(fos, 8192);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedOutputStream dest = (BufferedOutputStream)closeable;
                boolean bl5 = false;
                while (true) {
                    int n = tarIn.read(data, 0, 8192);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    int it2 = n;
                    boolean bl8 = false;
                    count.element = it2;
                    if (n == -1) break;
                    dest.write(data, 0, count.element);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private CliUtil() {
    }

    static {
        CliUtil cliUtil;
        INSTANCE = cliUtil = new CliUtil();
    }
}

