/*
 * Decompiled with CFR 0.152.
 */
package earth.levi.dotenv.util;

import earth.levi.dotenv.util.CliUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Learth/levi/dotenv/util/CliUtil;", "", "()V", "assertCliExist", "", "project", "Lorg/gradle/api/Project;", "assertCliVersionCompatible", "doesCliExist", "", "getCliVersion", "", "dotenv"})
public final class CliUtil {
    public static final CliUtil INSTANCE;

    public final boolean doesCliExist(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getCliVersion(project) != null;
    }

    public final void assertCliExist(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (this.doesCliExist(project)) {
            return;
        }
        String string = "Sorry! The dotenv-android gradle plugin requires you install a CLI tool before you can use this gradle plugin.";
        boolean bl = false;
        System.out.println((Object)string);
        string = "Install the CLI from the instructions here: https://github.com/levibostian/dotenv#install";
        bl = false;
        System.out.println((Object)string);
        throw (Throwable)new RuntimeException("Install dotenv CLI and try running plugin again. https://github.com/levibostian/dotenv#install");
    }

    public final void assertCliVersionCompatible(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Function1 getCompareString2 = assertCliVersionCompatible.getCompareString.1.INSTANCE;
        String string = this.getCliVersion(project);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String cliVersionInstalled = string;
        project.getLogger().log(LogLevel.DEBUG, "---Asserting CLI version compatible.");
        project.getLogger().log(LogLevel.DEBUG, "Installed CLI version: " + cliVersionInstalled);
        int currentInstalledVersionCompareString = ((Number)getCompareString2.invoke((Object)cliVersionInstalled)).intValue();
        int minVersionInstalled = ((Number)getCompareString2.invoke((Object)"1.0.0")).intValue();
        int maxVersionInstalled = ((Number)getCompareString2.invoke((Object)"2.0.0")).intValue();
        project.getLogger().log(LogLevel.DEBUG, "Version values to compare. Current installed: " + currentInstalledVersionCompareString + ", min: " + minVersionInstalled + ", max: " + maxVersionInstalled);
        boolean isCliVersionCompatible = currentInstalledVersionCompareString >= minVersionInstalled && currentInstalledVersionCompareString < maxVersionInstalled;
        project.getLogger().log(LogLevel.DEBUG, "is cli version compatible: " + isCliVersionCompatible);
        if (!isCliVersionCompatible) {
            String string2 = "dotenv-android gradle plugin ERROR";
            boolean bl = false;
            System.out.println((Object)string2);
            string2 = "Currently installed version of `dotenv` CLI out-of-date.";
            bl = false;
            System.out.println((Object)string2);
            string2 = "Minimum required version to install: 1.0.0 and must be less then 2.0.0 -- Currently installed version: " + cliVersionInstalled;
            bl = false;
            System.out.println((Object)string2);
            throw (Throwable)new RuntimeException("Currently installed version of dotenv CLI out of date");
        }
    }

    private final String getCliVersion(Project project) {
        String string;
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            project.exec((Action)new Action<ExecSpec>(byteOutputStream, project){
                final /* synthetic */ ByteArrayOutputStream $byteOutputStream;
                final /* synthetic */ Project $project;

                public final void execute(ExecSpec it) {
                    ExecSpec execSpec = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"it");
                    execSpec.setStandardOutput((OutputStream)this.$byteOutputStream);
                    it.setIgnoreExitValue(false);
                    it.setWorkingDir(this.$project.getBuildDir());
                    it.setExecutable("dotenv");
                    it.setArgs(CollectionsKt.listOf((Object)"version"));
                }
                {
                    this.$byteOutputStream = byteArrayOutputStream;
                    this.$project = project;
                }
            }).assertNormalExitValue();
            String string2 = byteOutputStream.toString(StandardCharsets.UTF_8);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"byteOutputStream.toString(StandardCharsets.UTF_8)");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        }
        catch (Exception error) {
            string = null;
        }
        return string;
    }

    private CliUtil() {
    }

    static {
        CliUtil cliUtil;
        INSTANCE = cliUtil = new CliUtil();
    }
}

