/*
 * Decompiled with CFR 0.152.
 */
package earth.levi.dotenv;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import earth.levi.dotenv.DotEnvPlugin;
import earth.levi.dotenv.DotEnvPluginExtension;
import earth.levi.dotenv.util.CliUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J \u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Learth/levi/dotenv/DotEnvPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "generateEnvForVariant", "extension", "Learth/levi/dotenv/DotEnvPluginExtension;", "generatedCodeOutputDir", "", "setupTasksForVariant", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "Companion", "dotenv"})
public final class DotEnvPlugin
implements Plugin<Project> {
    @NotNull
    public static final String PLUGIN_NAME = "dotenv";
    @NotNull
    public static final String COMPATIBLE_CLI_VERSION = "1.0.0";
    @NotNull
    public static final String NEXT_MAJOR_CLI_VERSION = "2";
    @NotNull
    public static final String DOTENV_CLI_MANUAL_INSTALL_INSTRUCTIONS = "https://github.com/levibostian/dotenv#install";
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DotEnvPluginExtension extension = (DotEnvPluginExtension)project.getExtensions().create(PLUGIN_NAME, DotEnvPluginExtension.class, new Object[0]);
        project.afterEvaluate((Action)new Action<Project>(this, extension){
            final /* synthetic */ DotEnvPlugin this$0;
            final /* synthetic */ DotEnvPluginExtension $extension;

            public final void execute(Project project) {
                block0: {
                    Project project2 = project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    AppExtension appExtension = (AppExtension)project2.getExtensions().findByType(AppExtension.class);
                    AppExtension appExtension2 = appExtension;
                    if (appExtension2 == null || (appExtension2 = appExtension2.getApplicationVariants()) == null) break block0;
                    appExtension2.all((Action)new Action<ApplicationVariant>(this, project){
                        final /* synthetic */ apply.1 this$0;
                        final /* synthetic */ Project $project;

                        public final void execute(ApplicationVariant buildVariant) {
                            DotEnvPlugin dotEnvPlugin = this.this$0.this$0;
                            DotEnvPluginExtension dotEnvPluginExtension = this.this$0.$extension;
                            Intrinsics.checkExpressionValueIsNotNull((Object)dotEnvPluginExtension, (String)"extension");
                            Project project = this.$project;
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                            ApplicationVariant applicationVariant = buildVariant;
                            Intrinsics.checkExpressionValueIsNotNull((Object)applicationVariant, (String)"buildVariant");
                            DotEnvPlugin.access$setupTasksForVariant(dotEnvPlugin, dotEnvPluginExtension, project, (BaseVariant)applicationVariant);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$project = project;
                        }
                    });
                }
            }
            {
                this.this$0 = dotEnvPlugin;
                this.$extension = dotEnvPluginExtension;
            }
        });
    }

    private final void setupTasksForVariant(DotEnvPluginExtension extension, Project project, BaseVariant variant) {
        SourceTask kotlinCompileTask;
        if (extension.getPackageName() == null) {
            extension.setPackageName(variant.getApplicationId());
        }
        String string = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
        String variantNameLowercase = StringsKt.decapitalize((String)string);
        String generatedCodeOutputDir = project.getBuildDir() + "/generated/source/dotenv/" + variantNameLowercase;
        StringBuilder stringBuilder = new StringBuilder().append("generate");
        String string2 = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variant.name");
        Task generateEnvTask2 = project.task(stringBuilder.append(StringsKt.capitalize((String)string2)).append("Dotenv").toString(), (Action)new Action<Task>(this, project, extension, generatedCodeOutputDir, variant){
            final /* synthetic */ DotEnvPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ DotEnvPluginExtension $extension;
            final /* synthetic */ String $generatedCodeOutputDir;
            final /* synthetic */ BaseVariant $variant;

            public final void execute(Task it) {
                it.doLast((Action)new Action<Task>(this){
                    final /* synthetic */ setupTasksForVariant.generateEnvTask.1 this$0;

                    public final void execute(Task it) {
                        String string = "=== dotenv-android plugin running ===";
                        boolean bl = false;
                        System.out.println((Object)string);
                        string = "dotenv-android info:";
                        bl = false;
                        System.out.println((Object)string);
                        string = "dotenv CLI compatible version: >= 1.0.0 && < 2";
                        bl = false;
                        System.out.println((Object)string);
                        CliUtil.INSTANCE.assertCliExist(this.this$0.$project);
                        CliUtil.INSTANCE.assertCliVersionCompatible(this.this$0.$project);
                        DotEnvPlugin.access$generateEnvForVariant(this.this$0.this$0, this.this$0.$project, this.this$0.$extension, this.this$0.$generatedCodeOutputDir);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Task task = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                task.setGroup("build");
                it.setDescription("Generate Env.java file for " + this.$variant.getName() + " build flavor from .env file");
            }
            {
                this.this$0 = dotEnvPlugin;
                this.$project = project;
                this.$extension = dotEnvPluginExtension;
                this.$generatedCodeOutputDir = string;
                this.$variant = baseVariant;
            }
        });
        variant.registerJavaGeneratingTask(generateEnvTask2, new File[]{new File(generatedCodeOutputDir)});
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder2 = new StringBuilder().append("compile");
        String string3 = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"variant.name");
        Object object = taskContainer.findByName(stringBuilder2.append(StringsKt.capitalize((String)string3)).append("Kotlin").toString());
        if (!(object instanceof SourceTask)) {
            object = null;
        }
        if ((kotlinCompileTask = (SourceTask)object) != null) {
            kotlinCompileTask.dependsOn(new Object[]{generateEnvTask2});
            SourceDirectorySet srcSet = project.getObjects().sourceDirectorySet(PLUGIN_NAME, PLUGIN_NAME).srcDir((Object)generatedCodeOutputDir);
            kotlinCompileTask.source(new Object[]{srcSet});
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateEnvForVariant(Project project, DotEnvPluginExtension extension, String generatedCodeOutputDir) {
        void path;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = Paths.get(generatedCodeOutputDir, new String[0]);
        String string = extension.getPackageName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            path.element = ((Path)path.element).resolve(it);
        }
        Files.createDirectories((Path)path.element, new FileAttribute[0]);
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        String sourcePath = FilesKt.resolve((File)file, (String)extension.getSourcePath()).getAbsolutePath();
        String packageName = extension.getPackageName();
        File file2 = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.rootDir");
        String dotEnvFilePath = file2.getAbsolutePath();
        project.getLogger().log(LogLevel.DEBUG, "source code path: " + sourcePath);
        project.getLogger().log(LogLevel.DEBUG, "package name: " + packageName);
        project.getLogger().log(LogLevel.DEBUG, ".env file path: " + dotEnvFilePath);
        project.getLogger().log(LogLevel.INFO, "Generating Env.java file");
        project.exec((Action)new Action<ExecSpec>((Ref.ObjectRef)path, packageName, sourcePath, dotEnvFilePath){
            final /* synthetic */ Ref.ObjectRef $path;
            final /* synthetic */ String $packageName;
            final /* synthetic */ String $sourcePath;
            final /* synthetic */ String $dotEnvFilePath;

            public final void execute(ExecSpec it) {
                ExecSpec execSpec = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"it");
                execSpec.setWorkingDir(((Path)this.$path.element).toFile());
                it.setExecutable("dotenv");
                it.setArgs(CollectionsKt.listOf((Object[])new String[]{"generate", "java", "--packageName", this.$packageName, "--source", this.$sourcePath, "--env", this.$dotEnvFilePath, "--inputLang", "java,kotlin", "--verbose"}));
                it.setIgnoreExitValue(false);
            }
            {
                this.$path = objectRef;
                this.$packageName = string;
                this.$sourcePath = string2;
                this.$dotEnvFilePath = string3;
            }
        });
    }

    public static final /* synthetic */ void access$setupTasksForVariant(DotEnvPlugin $this, DotEnvPluginExtension extension, Project project, BaseVariant variant) {
        $this.setupTasksForVariant(extension, project, variant);
    }

    public static final /* synthetic */ void access$generateEnvForVariant(DotEnvPlugin $this, Project project, DotEnvPluginExtension extension, String generatedCodeOutputDir) {
        $this.generateEnvForVariant(project, extension, generatedCodeOutputDir);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Learth/levi/dotenv/DotEnvPlugin$Companion;", "", "()V", "COMPATIBLE_CLI_VERSION", "", "DOTENV_CLI_MANUAL_INSTALL_INSTRUCTIONS", "NEXT_MAJOR_CLI_VERSION", "PLUGIN_NAME", "dotenv"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

