/*
 * Decompiled with CFR 0.152.
 */
package dwalldorf.jadecr.converter;

import dwalldorf.jadecr.converter.ConvertUtil;
import dwalldorf.jadecr.converter.Converter;
import dwalldorf.jadecr.exception.ConversionException;
import java.lang.reflect.Field;
import org.springframework.util.ReflectionUtils;

public class PropertyConverter
implements Converter {
    @Override
    public Object convert(Object src) throws ConversionException {
        if (!ConvertUtil.isConvertibleObject(src)) {
            return null;
        }
        try {
            Object dest = ConvertUtil.getNewDestInstance(src);
            this.copyValues(src, dest);
            return dest;
        }
        catch (Exception e) {
            throw new ConversionException(e.getMessage(), e);
        }
    }

    private void copyValues(Object src, Object dest) throws IllegalAccessException {
        ReflectionUtils.doWithFields(src.getClass(), field -> {
            Field destField = ReflectionUtils.findField(dest.getClass(), (String)field.getName());
            if (destField == null) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.makeAccessible((Field)destField);
            Object value = field.get(src);
            this.setValue(value, destField, dest);
        });
    }

    private void setValue(Object value, Field destField, Object dest) {
        if (value != null) {
            String destTypeName;
            String valueTypeName;
            if (ConvertUtil.isConvertibleObject(value)) {
                value = this.convert(value);
            }
            if ((valueTypeName = value.getClass().getName()).equals(destTypeName = destField.getType().getName())) {
                ReflectionUtils.setField((Field)destField, (Object)dest, (Object)value);
            }
        }
    }
}

