/*
 * Decompiled with CFR 0.152.
 */
package dwalldorf.jadecr.converter;

import dwalldorf.jadecr.converter.ConvertUtil;
import dwalldorf.jadecr.converter.Converter;
import dwalldorf.jadecr.exception.ConversionException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;

public class GetterSetterConverter
implements Converter {
    @Override
    public Object convert(Object src) throws ConversionException {
        if (!ConvertUtil.isConvertibleObject(src)) {
            return null;
        }
        try {
            Object dest = ConvertUtil.getNewDestInstance(src);
            this.copyValues(src, dest);
            return dest;
        }
        catch (Exception e) {
            throw new ConversionException(e.getMessage(), e);
        }
    }

    private void copyValues(Object src, Object dest) throws Exception {
        Method[] methods;
        for (Method method : methods = src.getClass().getMethods()) {
            Method setter;
            Optional<Method> optionalSetter;
            if (!this.isGetter(method)) continue;
            Object value = this.getValue(method, src);
            if (ConvertUtil.isConvertibleObject(value)) {
                optionalSetter = this.getSetter(method, dest, ConvertUtil.getConvertibleDestClass(value));
                if (!optionalSetter.isPresent()) continue;
                setter = optionalSetter.get();
                Object convertedValue = this.convert(value);
                this.setValue(convertedValue, setter, dest);
                continue;
            }
            optionalSetter = this.getSetter(method, dest);
            if (!optionalSetter.isPresent()) continue;
            setter = optionalSetter.get();
            this.setValue(value, setter, dest);
        }
    }

    private boolean isGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getTypeParameters().length > 0) {
            return false;
        }
        return Modifier.isPublic(method.getModifiers());
    }

    private Optional<Method> getSetter(Method getter, Object dest, Class valueType) {
        String setterName = "set" + getter.getName().substring(3);
        for (Method method : dest.getClass().getMethods()) {
            Class<?> setterParameterType;
            if (!this.isSetter(method) || !method.getName().equals(setterName) || !(setterParameterType = method.getParameterTypes()[0]).getName().equals(valueType.getName())) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private Optional<Method> getSetter(Method getter, Object dest) {
        Class<?> getterReturnType = getter.getReturnType();
        return this.getSetter(getter, dest, getterReturnType);
    }

    private boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getTypeParameters().length == 1) {
            return false;
        }
        return method.getModifiers() != 2;
    }

    private Object getValue(Method getter, Object src) throws Exception {
        return getter.invoke(src, new Object[0]);
    }

    private void setValue(Object value, Method setter, Object dest) throws Exception {
        setter.invoke(dest, value);
    }
}

