/*
 * Decompiled with CFR 0.152.
 */
package dwalldorf.jadecr;

import dwalldorf.jadecr.ConverterType;
import dwalldorf.jadecr.converter.Converter;
import dwalldorf.jadecr.converter.GetterSetterConverter;
import dwalldorf.jadecr.converter.PropertyConverter;
import java.util.HashMap;
import java.util.Map;

public class ConverterFactory {
    private static final Map<ConverterType, Converter> instanceMap = new HashMap<ConverterType, Converter>();
    private static ConverterType converterType = ConverterType.GETTER_SETTER;

    public static Converter getInstance() {
        if (!instanceMap.containsKey((Object)converterType)) {
            instanceMap.put(converterType, ConverterFactory.createInstance(converterType));
        }
        return instanceMap.get((Object)converterType);
    }

    public static void configureType(ConverterType type) {
        converterType = type;
    }

    private static Converter createInstance(ConverterType type) {
        switch (type) {
            case GETTER_SETTER: {
                return new GetterSetterConverter();
            }
            case CLASS_MEMBER: {
                return new PropertyConverter();
            }
        }
        return null;
    }
}

