/*
 * Decompiled with CFR 0.152.
 */
package drewhamilton.skylight.sso;

import drewhamilton.skylight.Coordinates;
import drewhamilton.skylight.Skylight;
import drewhamilton.skylight.SkylightDay;
import drewhamilton.skylight.sso.SsoSkylightKt;
import drewhamilton.skylight.sso.network.SsoApi;
import drewhamilton.skylight.sso.network.SsoDateFormatKt;
import drewhamilton.skylight.sso.network.request.Params;
import drewhamilton.skylight.sso.network.response.SsoInfoResponse;
import drewhamilton.skylight.sso.network.response.SunriseSunsetInfo;
import java.time.LocalDate;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldrewhamilton/skylight/sso/SsoSkylight;", "Ldrewhamilton/skylight/Skylight;", "api", "Ldrewhamilton/skylight/sso/network/SsoApi;", "(Ldrewhamilton/skylight/sso/network/SsoApi;)V", "getInfoResults", "Ldrewhamilton/skylight/sso/network/response/SunriseSunsetInfo;", "params", "Ldrewhamilton/skylight/sso/network/request/Params;", "getSkylightDay", "Ldrewhamilton/skylight/SkylightDay;", "coordinates", "Ldrewhamilton/skylight/Coordinates;", "date", "Ljava/time/LocalDate;", "sso"})
public final class SsoSkylight
implements Skylight {
    private final SsoApi api;

    @NotNull
    public SkylightDay getSkylightDay(@NotNull Coordinates coordinates, @NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)coordinates, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        double d = coordinates.getLatitude();
        double d2 = coordinates.getLongitude();
        String string = SsoDateFormatKt.toSsoDateString(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"date.toSsoDateString()");
        Params params = new Params(d, d2, string);
        return SsoSkylightKt.toSkylightDay(this.getInfoResults(params), date);
    }

    private final SunriseSunsetInfo getInfoResults(Params params) {
        Call call = SsoApi.DefaultImpls.getInfo$default(this.api, params.getLat(), params.getLng(), params.getDate(), 0, 8, null);
        Response response = call.execute();
        SsoInfoResponse responseBody = (SsoInfoResponse)response.body();
        Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (response2.isSuccessful() && responseBody != null) {
            return responseBody.getResults();
        }
        throw (Throwable)new HttpException(response);
    }

    @Inject
    public SsoSkylight(@NotNull SsoApi api) {
        Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
        this.api = api;
    }
}

