/*
 * Decompiled with CFR 0.152.
 */
package drewhamilton.skylight.calculator;

import dagger.Reusable;
import drewhamilton.skylight.Coordinates;
import drewhamilton.skylight.Skylight;
import drewhamilton.skylight.SkylightDay;
import drewhamilton.skylight.calculator.CalculatorKt;
import drewhamilton.skylight.calculator.EpochMilliSkylightDay;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Reusable
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nH\u0002J\u0014\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\r*\u00020\bH\u0002J\u0014\u0010\u000f\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Ldrewhamilton/skylight/calculator/CalculatorSkylight;", "Ldrewhamilton/skylight/Skylight;", "()V", "getSkylightDay", "Ldrewhamilton/skylight/SkylightDay;", "coordinates", "Ldrewhamilton/skylight/Coordinates;", "date", "Ljava/time/LocalDate;", "noonUtc", "Ljava/time/OffsetTime;", "kotlin.jvm.PlatformType", "asEpochMilliToUtcOffsetTime", "", "toNoonUtcEpochMillis", "toSkylightDay", "Ldrewhamilton/skylight/calculator/EpochMilliSkylightDay;", "calculator"})
public final class CalculatorSkylight
implements Skylight {
    @NotNull
    public SkylightDay getSkylightDay(@NotNull Coordinates coordinates, @NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)coordinates, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        long epochMillis = this.toNoonUtcEpochMillis(date);
        return this.toSkylightDay(CalculatorKt.calculateSkylightInfo$default(epochMillis, coordinates.getLatitude(), coordinates.getLongitude(), 0.0f, 0.0f, 24, null), date);
    }

    private final OffsetTime noonUtc() {
        return OffsetTime.of(12, 0, 0, 0, ZoneOffset.UTC);
    }

    private final long toNoonUtcEpochMillis(@NotNull LocalDate $this$toNoonUtcEpochMillis) {
        return $this$toNoonUtcEpochMillis.atTime(this.noonUtc()).toInstant().toEpochMilli();
    }

    private final SkylightDay toSkylightDay(@NotNull EpochMilliSkylightDay $this$toSkylightDay, LocalDate date) {
        SkylightDay skylightDay;
        EpochMilliSkylightDay epochMilliSkylightDay = $this$toSkylightDay;
        if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.Typical) {
            OffsetTime offsetTime = this.asEpochMilliToUtcOffsetTime(((EpochMilliSkylightDay.Typical)$this$toSkylightDay).getDawn());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime, (String)"dawn.asEpochMilliToUtcOffsetTime()");
            OffsetTime offsetTime2 = this.asEpochMilliToUtcOffsetTime(((EpochMilliSkylightDay.Typical)$this$toSkylightDay).getSunrise());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime2, (String)"sunrise.asEpochMilliToUtcOffsetTime()");
            OffsetTime offsetTime3 = this.asEpochMilliToUtcOffsetTime(((EpochMilliSkylightDay.Typical)$this$toSkylightDay).getSunset());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime3, (String)"sunset.asEpochMilliToUtcOffsetTime()");
            OffsetTime offsetTime4 = this.asEpochMilliToUtcOffsetTime(((EpochMilliSkylightDay.Typical)$this$toSkylightDay).getDusk());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime4, (String)"dusk.asEpochMilliToUtcOffsetTime()");
            skylightDay = (SkylightDay)new SkylightDay.Typical(date, offsetTime, offsetTime2, offsetTime3, offsetTime4);
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.AlwaysDaytime) {
            skylightDay = (SkylightDay)new SkylightDay.AlwaysDaytime(date);
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.AlwaysLight) {
            OffsetTime offsetTime = this.asEpochMilliToUtcOffsetTime(((EpochMilliSkylightDay.AlwaysLight)$this$toSkylightDay).getSunrise());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime, (String)"sunrise.asEpochMilliToUtcOffsetTime()");
            OffsetTime offsetTime5 = this.asEpochMilliToUtcOffsetTime(((EpochMilliSkylightDay.AlwaysLight)$this$toSkylightDay).getSunset());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime5, (String)"sunset.asEpochMilliToUtcOffsetTime()");
            skylightDay = (SkylightDay)new SkylightDay.AlwaysLight(date, offsetTime, offsetTime5);
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.NeverDaytime) {
            OffsetTime offsetTime = this.asEpochMilliToUtcOffsetTime(((EpochMilliSkylightDay.NeverDaytime)$this$toSkylightDay).getDawn());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime, (String)"dawn.asEpochMilliToUtcOffsetTime()");
            OffsetTime offsetTime6 = this.asEpochMilliToUtcOffsetTime(((EpochMilliSkylightDay.NeverDaytime)$this$toSkylightDay).getDusk());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime6, (String)"dusk.asEpochMilliToUtcOffsetTime()");
            skylightDay = (SkylightDay)new SkylightDay.NeverDaytime(date, offsetTime, offsetTime6);
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.NeverLight) {
            skylightDay = (SkylightDay)new SkylightDay.NeverLight(date);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return skylightDay;
    }

    private final OffsetTime asEpochMilliToUtcOffsetTime(long $this$asEpochMilliToUtcOffsetTime) {
        return OffsetTime.ofInstant(Instant.ofEpochMilli($this$asEpochMilliToUtcOffsetTime), ZoneOffset.UTC);
    }

    @Inject
    public CalculatorSkylight() {
    }
}

