/*
 * Decompiled with CFR 0.152.
 */
package drewhamilton.skylight.calculator;

import dagger.Reusable;
import drewhamilton.skylight.Coordinates;
import drewhamilton.skylight.Skylight;
import drewhamilton.skylight.SkylightDay;
import drewhamilton.skylight.calculator.CalculatorKt;
import drewhamilton.skylight.calculator.EpochMilliSkylightDay;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Reusable
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\u0010*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Ldrewhamilton/skylight/calculator/CalculatorSkylight;", "Ldrewhamilton/skylight/Skylight;", "()V", "getSkylightDay", "Ldrewhamilton/skylight/SkylightDay;", "coordinates", "Ldrewhamilton/skylight/Coordinates;", "date", "Ljava/time/LocalDate;", "zoneId", "Ljava/time/ZoneId;", "noonToday", "Ljava/time/OffsetTime;", "kotlin.jvm.PlatformType", "asEpochMilliToDateTime", "Ljava/time/ZonedDateTime;", "", "(Ljava/lang/Long;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;", "toNoonUtcEpochMillis", "toSkylightDay", "Ldrewhamilton/skylight/calculator/EpochMilliSkylightDay;", "calculator"})
public final class CalculatorSkylight
implements Skylight {
    @NotNull
    public SkylightDay getSkylightDay(@NotNull Coordinates coordinates, @NotNull LocalDate date, @NotNull ZoneId zoneId) {
        Intrinsics.checkParameterIsNotNull((Object)coordinates, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)zoneId, (String)"zoneId");
        long epochMillis = this.toNoonUtcEpochMillis(date, zoneId);
        return this.toSkylightDay(CalculatorKt.calculateSkylightInfo$default(epochMillis, coordinates.getLatitude(), coordinates.getLongitude(), 0.0f, 0.0f, 24, null), date, zoneId);
    }

    private final long toNoonUtcEpochMillis(@NotNull LocalDate $this$toNoonUtcEpochMillis, ZoneId zoneId) {
        return $this$toNoonUtcEpochMillis.atTime(this.noonToday(zoneId)).toInstant().toEpochMilli();
    }

    private final OffsetTime noonToday(ZoneId zoneId) {
        return OffsetTime.of(12, 0, 0, 0, zoneId.getRules().getOffset(Instant.now()));
    }

    private final SkylightDay toSkylightDay(@NotNull EpochMilliSkylightDay $this$toSkylightDay, LocalDate date, ZoneId zoneId) {
        SkylightDay skylightDay;
        EpochMilliSkylightDay epochMilliSkylightDay = $this$toSkylightDay;
        if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.Typical) {
            skylightDay = (SkylightDay)SkylightDay.Companion.Typical((Function1)new Function1<SkylightDay.Typical.Builder, Unit>(this, $this$toSkylightDay, date, zoneId){
                final /* synthetic */ CalculatorSkylight this$0;
                final /* synthetic */ EpochMilliSkylightDay $this_toSkylightDay;
                final /* synthetic */ LocalDate $date;
                final /* synthetic */ ZoneId $zoneId;

                public final void invoke(@NotNull SkylightDay.Typical.Builder $this$Typical) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$Typical, (String)"$receiver");
                    $this$Typical.setDate(this.$date);
                    $this$Typical.setDawn(CalculatorSkylight.access$asEpochMilliToDateTime(this.this$0, ((EpochMilliSkylightDay.Typical)this.$this_toSkylightDay).getDawn(), this.$zoneId));
                    $this$Typical.setSunrise(CalculatorSkylight.access$asEpochMilliToDateTime(this.this$0, ((EpochMilliSkylightDay.Typical)this.$this_toSkylightDay).getSunrise(), this.$zoneId));
                    $this$Typical.setSunset(CalculatorSkylight.access$asEpochMilliToDateTime(this.this$0, ((EpochMilliSkylightDay.Typical)this.$this_toSkylightDay).getSunset(), this.$zoneId));
                    $this$Typical.setDusk(CalculatorSkylight.access$asEpochMilliToDateTime(this.this$0, ((EpochMilliSkylightDay.Typical)this.$this_toSkylightDay).getDusk(), this.$zoneId));
                }
                {
                    this.this$0 = calculatorSkylight;
                    this.$this_toSkylightDay = epochMilliSkylightDay;
                    this.$date = localDate;
                    this.$zoneId = zoneId;
                    super(1);
                }
            });
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.AlwaysDaytime) {
            skylightDay = (SkylightDay)SkylightDay.Companion.AlwaysDaytime((Function1)new Function1<SkylightDay.AlwaysDaytime.Builder, Unit>(date){
                final /* synthetic */ LocalDate $date;

                public final void invoke(@NotNull SkylightDay.AlwaysDaytime.Builder $this$AlwaysDaytime) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$AlwaysDaytime, (String)"$receiver");
                    $this$AlwaysDaytime.setDate(this.$date);
                }
                {
                    this.$date = localDate;
                    super(1);
                }
            });
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.NeverLight) {
            skylightDay = (SkylightDay)SkylightDay.Companion.NeverLight((Function1)new Function1<SkylightDay.NeverLight.Builder, Unit>(date){
                final /* synthetic */ LocalDate $date;

                public final void invoke(@NotNull SkylightDay.NeverLight.Builder $this$NeverLight) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$NeverLight, (String)"$receiver");
                    $this$NeverLight.setDate(this.$date);
                }
                {
                    this.$date = localDate;
                    super(1);
                }
            });
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return skylightDay;
    }

    private final ZonedDateTime asEpochMilliToDateTime(@Nullable Long $this$asEpochMilliToDateTime, ZoneId zoneId) {
        return $this$asEpochMilliToDateTime == null ? null : ZonedDateTime.ofInstant(Instant.ofEpochMilli($this$asEpochMilliToDateTime), zoneId);
    }

    @Inject
    public CalculatorSkylight() {
    }

    public static final /* synthetic */ ZonedDateTime access$asEpochMilliToDateTime(CalculatorSkylight $this, Long $this$access_u24asEpochMilliToDateTime, ZoneId zoneId) {
        return $this.asEpochMilliToDateTime($this$access_u24asEpochMilliToDateTime, zoneId);
    }
}

