/*
 * Decompiled with CFR 0.152.
 */
package drewhamilton.skylight.calculator;

import drewhamilton.skylight.calculator.EpochMilliSkylightDay;
import kotlin.Metadata;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a4\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\b\b\u0002\u0010\u001b\u001a\u00020\u00012\b\b\u0002\u0010\u001c\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"C1", "", "C2", "C3", "CORRECTION_SOLAR_TRANSIT", "", "DAY_IN_MILLIS", "", "DEGREES_TO_RADIANS", "OBLIQUITY", "UNIX_NOON_UTC_2000", "", "calculateCosineHourAngle", "altitudeCorrection", "latRad", "solarDec", "calculateEveningEventUnixTime", "solarTransitJ2000", "hourAngle", "calculateMeanAnomaly", "daysSince2000", "calculateMorningEventUnixTime", "calculateSkylightInfo", "Ldrewhamilton/skylight/calculator/EpochMilliSkylightDay;", "epochMillis", "latitude", "longitude", "altitudeRadiansCivilTwilight", "altitudeRadiansHorizon", "calculateTrueAnomaly", "meanAnomaly", "isAlwaysDay", "", "cosHourAngle", "isAlwaysNight", "calculator"})
public final class CalculatorKt {
    private static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    private static final int DAY_IN_MILLIS = 86400000;
    private static final long UNIX_NOON_UTC_2000 = 946728000000L;
    private static final double CORRECTION_SOLAR_TRANSIT = 9.0E-4;
    private static final float C1 = 0.0334196f;
    private static final float C2 = 3.49066E-4f;
    private static final float C3 = 5.236E-6f;
    private static final float OBLIQUITY = 0.4092797f;

    @NotNull
    public static final EpochMilliSkylightDay calculateSkylightInfo(long epochMillis, double latitude, double longitude, float altitudeRadiansCivilTwilight, float altitudeRadiansHorizon) {
        EpochMilliSkylightDay epochMilliSkylightDay;
        float daysSince2000 = (float)(epochMillis - 946728000000L) / (float)86400000;
        float meanAnomaly = CalculatorKt.calculateMeanAnomaly(daysSince2000);
        double trueAnomaly = CalculatorKt.calculateTrueAnomaly(meanAnomaly);
        double solarLongitude = trueAnomaly + 1.796593063 + Math.PI;
        double arcLongitude = -longitude / (double)360;
        float n = MathKt.roundToInt((double)((double)daysSince2000 - 9.0E-4 - arcLongitude));
        double d = meanAnomaly;
        double d2 = 0.0053;
        double d3 = (double)n + 9.0E-4 + arcLongitude;
        boolean bl = false;
        double d4 = Math.sin(d);
        double d5 = d3 + d2 * d4;
        d = (double)2 * solarLongitude;
        d2 = -0.0069;
        d3 = d5;
        bl = false;
        d4 = Math.sin(d);
        double solarTransitJ2000 = d3 + d2 * d4;
        bl = false;
        double d6 = 0.4092797f;
        d3 = Math.sin(solarLongitude);
        boolean bl2 = false;
        d2 = Math.sin(d6);
        d6 = d3 * d2;
        bl2 = false;
        double solarDec = Math.asin(d6);
        double latitudeRadians = latitude * (double)((float)Math.PI / 180);
        double cosHourAngleTwilight = CalculatorKt.calculateCosineHourAngle(altitudeRadiansCivilTwilight, latitudeRadians, solarDec);
        double cosHourAngleHorizon = CalculatorKt.calculateCosineHourAngle(altitudeRadiansHorizon, latitudeRadians, solarDec);
        if (CalculatorKt.isAlwaysNight(cosHourAngleTwilight)) {
            epochMilliSkylightDay = EpochMilliSkylightDay.NeverLight.INSTANCE;
        } else if (CalculatorKt.isAlwaysDay(cosHourAngleHorizon)) {
            epochMilliSkylightDay = EpochMilliSkylightDay.AlwaysDaytime.INSTANCE;
        } else {
            boolean bl3 = false;
            float hourAngleTwilight = (float)(Math.acos(cosHourAngleTwilight) / (Math.PI * 2));
            long dawn = CalculatorKt.calculateMorningEventUnixTime(solarTransitJ2000, hourAngleTwilight);
            long dusk = CalculatorKt.calculateEveningEventUnixTime(solarTransitJ2000, hourAngleTwilight);
            boolean bl4 = false;
            float hourAngleHorizon = (float)(Math.acos(cosHourAngleHorizon) / (Math.PI * 2));
            long sunrise = CalculatorKt.calculateMorningEventUnixTime(solarTransitJ2000, hourAngleHorizon);
            long sunset = CalculatorKt.calculateEveningEventUnixTime(solarTransitJ2000, hourAngleHorizon);
            epochMilliSkylightDay = CalculatorKt.isAlwaysDay(cosHourAngleTwilight) ? new EpochMilliSkylightDay.Typical(null, sunrise, sunset, null) : (CalculatorKt.isAlwaysNight(cosHourAngleHorizon) ? new EpochMilliSkylightDay.Typical(dawn, null, null, dusk) : new EpochMilliSkylightDay.Typical(dawn, sunrise, sunset, dusk));
        }
        return epochMilliSkylightDay;
    }

    public static /* synthetic */ EpochMilliSkylightDay calculateSkylightInfo$default(long l, double d, double d2, float f, float f2, int n, Object object) {
        if ((n & 8) != 0) {
            f = -0.10471976f;
        }
        if ((n & 0x10) != 0) {
            f2 = -0.01f;
        }
        return CalculatorKt.calculateSkylightInfo(l, d, d2, f, f2);
    }

    private static final float calculateMeanAnomaly(float daysSince2000) {
        return 6.24006f + daysSince2000 * 0.01720197f;
    }

    private static final double calculateTrueAnomaly(float meanAnomaly) {
        double d = meanAnomaly;
        double d2 = 0.0334196f;
        double d3 = meanAnomaly;
        boolean bl = false;
        double d4 = Math.sin(d);
        double d5 = d3 + d2 * d4;
        d = 2.0 * (double)meanAnomaly;
        d2 = 3.49066E-4f;
        d3 = d5;
        bl = false;
        d4 = Math.sin(d);
        double d6 = d3 + d2 * d4;
        d = 3.0 * (double)meanAnomaly;
        d2 = 5.236E-6f;
        d3 = d6;
        bl = false;
        d4 = Math.sin(d);
        return d3 + d2 * d4;
    }

    private static final double calculateCosineHourAngle(float altitudeCorrection, double latRad, double solarDec) {
        double d = altitudeCorrection;
        boolean bl = false;
        double d2 = Math.sin(d);
        boolean bl2 = false;
        double d3 = Math.sin(latRad);
        bl2 = false;
        double d4 = Math.sin(solarDec);
        d2 -= d3 * d4;
        bl2 = false;
        d3 = Math.cos(latRad);
        bl2 = false;
        d4 = Math.cos(solarDec);
        return d2 / (d3 * d4);
    }

    private static final boolean isAlwaysDay(double cosHourAngle) {
        return cosHourAngle <= (double)-1;
    }

    private static final boolean isAlwaysNight(double cosHourAngle) {
        return cosHourAngle >= 1.0;
    }

    private static final long calculateMorningEventUnixTime(double solarTransitJ2000, float hourAngle) {
        return MathKt.roundToLong((double)((solarTransitJ2000 - (double)hourAngle) * (double)86400000)) + 946728000000L;
    }

    private static final long calculateEveningEventUnixTime(double solarTransitJ2000, float hourAngle) {
        return CalculatorKt.calculateMorningEventUnixTime(solarTransitJ2000, -hourAngle);
    }
}

