/*
 * Decompiled with CFR 0.152.
 */
package drewhamilton.skylight.calculator;

import dagger.Reusable;
import drewhamilton.skylight.Coordinates;
import drewhamilton.skylight.Skylight;
import drewhamilton.skylight.SkylightDay;
import drewhamilton.skylight.calculator.CalculatorKt;
import drewhamilton.skylight.calculator.EpochMilliSkylightDay;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Reusable
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nH\u0002J\u0014\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\r*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\bH\u0002J\u0014\u0010\u0010\u001a\u00020\u0004*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Ldrewhamilton/skylight/calculator/CalculatorSkylight;", "Ldrewhamilton/skylight/Skylight;", "()V", "getSkylightDay", "Ldrewhamilton/skylight/SkylightDay;", "coordinates", "Ldrewhamilton/skylight/Coordinates;", "date", "Ljava/time/LocalDate;", "noonUtc", "Ljava/time/OffsetTime;", "kotlin.jvm.PlatformType", "asEpochMilliToUtcDateTime", "Ljava/time/ZonedDateTime;", "", "toNoonUtcEpochMillis", "toSkylightDay", "Ldrewhamilton/skylight/calculator/EpochMilliSkylightDay;", "calculator"})
public final class CalculatorSkylight
implements Skylight {
    @NotNull
    public SkylightDay getSkylightDay(@NotNull Coordinates coordinates, @NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)coordinates, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        long epochMillis = this.toNoonUtcEpochMillis(date);
        return this.toSkylightDay(CalculatorKt.calculateSkylightInfo$default(epochMillis, coordinates.getLatitude(), coordinates.getLongitude(), 0.0f, 0.0f, 24, null), date);
    }

    private final OffsetTime noonUtc() {
        return OffsetTime.of(12, 0, 0, 0, ZoneOffset.UTC);
    }

    private final long toNoonUtcEpochMillis(@NotNull LocalDate $this$toNoonUtcEpochMillis) {
        return $this$toNoonUtcEpochMillis.atTime(this.noonUtc()).toInstant().toEpochMilli();
    }

    private final SkylightDay toSkylightDay(@NotNull EpochMilliSkylightDay $this$toSkylightDay, LocalDate date) {
        SkylightDay skylightDay;
        EpochMilliSkylightDay epochMilliSkylightDay = $this$toSkylightDay;
        if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.Typical) {
            ZonedDateTime zonedDateTime = this.asEpochMilliToUtcDateTime(((EpochMilliSkylightDay.Typical)$this$toSkylightDay).getDawn());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"dawn.asEpochMilliToUtcDateTime()");
            ZonedDateTime zonedDateTime2 = this.asEpochMilliToUtcDateTime(((EpochMilliSkylightDay.Typical)$this$toSkylightDay).getSunrise());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime2, (String)"sunrise.asEpochMilliToUtcDateTime()");
            ZonedDateTime zonedDateTime3 = this.asEpochMilliToUtcDateTime(((EpochMilliSkylightDay.Typical)$this$toSkylightDay).getSunset());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime3, (String)"sunset.asEpochMilliToUtcDateTime()");
            ZonedDateTime zonedDateTime4 = this.asEpochMilliToUtcDateTime(((EpochMilliSkylightDay.Typical)$this$toSkylightDay).getDusk());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime4, (String)"dusk.asEpochMilliToUtcDateTime()");
            skylightDay = (SkylightDay)new SkylightDay.Typical(zonedDateTime, zonedDateTime2, zonedDateTime3, zonedDateTime4);
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.AlwaysDaytime) {
            skylightDay = (SkylightDay)new SkylightDay.AlwaysDaytime(date);
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.AlwaysLight) {
            ZonedDateTime zonedDateTime = this.asEpochMilliToUtcDateTime(((EpochMilliSkylightDay.AlwaysLight)$this$toSkylightDay).getSunrise());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"sunrise.asEpochMilliToUtcDateTime()");
            ZonedDateTime zonedDateTime5 = this.asEpochMilliToUtcDateTime(((EpochMilliSkylightDay.AlwaysLight)$this$toSkylightDay).getSunset());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime5, (String)"sunset.asEpochMilliToUtcDateTime()");
            skylightDay = (SkylightDay)new SkylightDay.AlwaysLight(zonedDateTime, zonedDateTime5);
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.NeverDaytime) {
            ZonedDateTime zonedDateTime = this.asEpochMilliToUtcDateTime(((EpochMilliSkylightDay.NeverDaytime)$this$toSkylightDay).getDawn());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"dawn.asEpochMilliToUtcDateTime()");
            ZonedDateTime zonedDateTime6 = this.asEpochMilliToUtcDateTime(((EpochMilliSkylightDay.NeverDaytime)$this$toSkylightDay).getDusk());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime6, (String)"dusk.asEpochMilliToUtcDateTime()");
            skylightDay = (SkylightDay)new SkylightDay.NeverDaytime(zonedDateTime, zonedDateTime6);
        } else if (epochMilliSkylightDay instanceof EpochMilliSkylightDay.NeverLight) {
            skylightDay = (SkylightDay)new SkylightDay.NeverLight(date);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return skylightDay;
    }

    private final ZonedDateTime asEpochMilliToUtcDateTime(long $this$asEpochMilliToUtcDateTime) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli($this$asEpochMilliToUtcDateTime), ZoneOffset.UTC);
    }

    @Inject
    public CalculatorSkylight() {
    }
}

