/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.RefAddr;
import javax.naming.StringRefAddr;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.naming.ResourceRef;

public final class Config {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Resource {
        private String name;
        private String type;
        private final Map parameters = new HashMap();

        public void addParameter(String name, String value) {
            this.parameters.put(name, value);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map getParameters() {
            return this.parameters;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object createValue() {
            ResourceRef ref = new ResourceRef(this.type, null, null, null);
            Iterator i = this.parameters.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = (String)this.parameters.get(name);
                ref.add((RefAddr)new StringRefAddr(name, value));
            }
            return ref;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("name", (Object)this.name).append("type", (Object)this.type).append("parameters", (Object)this.parameters).toString();
        }
    }

    public static final class Environment {
        private String name;
        private String value;
        private String type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("name", (Object)this.name).append("type", (Object)this.type).append("value", (Object)this.value).toString();
        }

        public Object createValue() {
            if (this.type.equals((class$java$lang$String == null ? (class$java$lang$String = Config.class$("java.lang.String")) : class$java$lang$String).getName())) {
                return this.value;
            }
            if (this.type.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = Config.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
                return Boolean.valueOf(this.value);
            }
            if (this.type.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = Config.class$("java.lang.Integer")) : class$java$lang$Integer).getName())) {
                return Integer.valueOf(this.value);
            }
            if (this.type.equals((class$java$lang$Short == null ? (class$java$lang$Short = Config.class$("java.lang.Short")) : class$java$lang$Short).getName())) {
                return Short.valueOf(this.value);
            }
            if (this.type.equals((class$java$lang$Character == null ? (class$java$lang$Character = Config.class$("java.lang.Character")) : class$java$lang$Character).getName())) {
                return new Character(this.value.charAt(0));
            }
            if (this.type.equals((class$java$lang$Double == null ? (class$java$lang$Double = Config.class$("java.lang.Double")) : class$java$lang$Double).getName())) {
                return Double.valueOf(this.value);
            }
            if (this.type.equals((class$java$lang$Float == null ? (class$java$lang$Float = Config.class$("java.lang.Float")) : class$java$lang$Float).getName())) {
                return Float.valueOf(this.value);
            }
            if (this.type.equals((class$java$lang$Byte == null ? (class$java$lang$Byte = Config.class$("java.lang.Byte")) : class$java$lang$Byte).getName())) {
                return Byte.valueOf(this.value);
            }
            if (this.type.equals((class$java$lang$Long == null ? (class$java$lang$Long = Config.class$("java.lang.Long")) : class$java$lang$Long).getName())) {
                return Long.valueOf(this.value);
            }
            return null;
        }
    }

    public static final class Context {
        private String name;
        private final Collection environmentList = new LinkedList();
        private final Collection resourceList = new LinkedList();

        public void addEnvironment(Environment environment) {
            this.environmentList.add(environment);
        }

        public void addSubContextNames(Set sortedSubcontextNameSet) throws InvalidNameException {
            CompositeName name;
            if (this.name != null && !this.environmentList.iterator().hasNext() && !this.resourceList.iterator().hasNext()) {
                sortedSubcontextNameSet.add(this.name);
            }
            Iterator i = this.environmentList.iterator();
            while (i.hasNext()) {
                Environment e = (Environment)i.next();
                name = new CompositeName(e.getName());
                this.addSubContextNames(name, sortedSubcontextNameSet);
            }
            i = this.resourceList.iterator();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                name = new CompositeName(r.getName());
                this.addSubContextNames(name, sortedSubcontextNameSet);
            }
        }

        private void addSubContextNames(CompositeName name, Set sortedSubcontextNameSet) {
            for (int j = 1; j <= name.size() - 1; ++j) {
                sortedSubcontextNameSet.add(name.getPrefix(j).toString());
            }
        }

        public void addResource(Resource resource) {
            this.resourceList.add(resource);
        }

        public Collection getEnvironmentList() {
            return Collections.unmodifiableCollection(this.environmentList);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Collection getResourceList() {
            return Collections.unmodifiableCollection(this.resourceList);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("name", (Object)this.name).append("environmentList", (Object)this.environmentList).append("resourceList", (Object)this.resourceList).toString();
        }
    }

    public static final class Naming {
        private final Collection contextList = new LinkedList();

        public void addContext(Context context) {
            this.contextList.add(context);
        }

        public Collection getContextList() {
            return Collections.unmodifiableCollection(this.contextList);
        }

        public Set generateSortedSubcontextNameSet() throws InvalidNameException {
            TreeSet sortedSubcontextNameSet = new TreeSet();
            Iterator i = this.contextList.iterator();
            while (i.hasNext()) {
                Context context = (Context)i.next();
                context.addSubContextNames(sortedSubcontextNameSet);
            }
            return Collections.unmodifiableSet(sortedSubcontextNameSet);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("contextList", (Object)this.contextList).toString();
        }
    }
}

