/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.Auth;
import digital.toke.DefaultHousekeepingImpl;
import digital.toke.Token;
import digital.toke.TokenRenewal;
import digital.toke.event.EventEnum;
import digital.toke.event.RenewalTokenEvent;
import digital.toke.event.TokenEvent;
import digital.toke.event.TokenListener;
import digital.toke.exception.OutOfTokensException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenManager {
    private static final Logger logger = LogManager.getLogger(TokenManager.class);
    private final Auth auth;
    private final Set<Token> tokens;
    private final List<TokenListener> listeners;
    private ScheduledExecutorService scheduledPool;

    public TokenManager(Auth auth) {
        this.auth = auth;
        this.tokens = new HashSet<Token>();
        this.listeners = new ArrayList<TokenListener>();
        this.initScheduler();
    }

    private void initScheduler() {
        this.scheduledPool = Executors.newScheduledThreadPool(1);
        logger.info("Initializing scheduler...");
        this.scheduledPool.scheduleWithFixedDelay(new DefaultHousekeepingImpl(this), 1L, 30L, TimeUnit.SECONDS);
        logger.info("Initialized a TokenManager instance");
    }

    public Token bestTokenFor(String path) throws OutOfTokensException {
        if (this.tokens.size() == 0) {
            throw new OutOfTokensException();
        }
        Iterator<Token> iter = this.tokens.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public void fireTokenEvent(TokenEvent evt) {
        for (TokenListener l : this.listeners) {
            l.tokenEvent(evt);
        }
    }

    public void fireLoginEvent(Token token) {
        logger.info("Firing successful login event...");
        logger.debug(token.getJson().toString());
        this.fireTokenEvent(new TokenEvent(this, token, EventEnum.LOGIN));
    }

    public void updateManagedSet(List<TokenRenewal> list) {
        if (list.size() == 0) {
            return;
        }
        this.fireTokenEvent(new RenewalTokenEvent((Object)this, list));
        Set<Token> set = this.getManagedTokens();
        for (TokenRenewal tr : list) {
            if (!set.contains(tr.oldToken)) continue;
            set.remove(tr.oldToken);
        }
        for (TokenRenewal tr : list) {
            set.add(tr.newToken);
        }
    }

    public void addTokenListener(TokenListener listener) {
        this.listeners.add(listener);
    }

    public Auth getAuth() {
        return this.auth;
    }

    public Set<Token> getManagedTokens() {
        return this.tokens;
    }
}

