/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Token {
    private static final Logger logger = LogManager.getLogger(Token.class);
    static DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    final JSONObject json;
    final boolean fromSuccessfulLoginRequest;
    final JSONObject lookupData;

    public Token(JSONObject json, boolean valid) {
        this.json = json;
        this.fromSuccessfulLoginRequest = valid;
        this.lookupData = new JSONObject();
    }

    public Token(JSONObject json, boolean valid, JSONObject lookupData) {
        this.json = json;
        this.fromSuccessfulLoginRequest = valid;
        this.lookupData = lookupData;
    }

    public String clientToken() {
        JSONObject auth = this.json.optJSONObject("auth");
        if (auth == null) {
            return "";
        }
        return auth.getString("client_token");
    }

    public String accessor() {
        JSONObject auth = this.json.optJSONObject("auth");
        if (auth == null) {
            return "";
        }
        return auth.getString("accessor");
    }

    public boolean isRenewable() {
        JSONObject auth = this.json.optJSONObject("auth");
        if (auth == null) {
            throw new RuntimeException("Bad data?");
        }
        return auth.optBoolean("renewable", false);
    }

    public int period() {
        JSONObject auth = this.json.optJSONObject("auth");
        if (auth == null) {
            throw new RuntimeException("Bad data?");
        }
        return auth.optInt("period", -1);
    }

    public boolean isPeriodic() {
        return this.period() != -1;
    }

    public boolean isRoot() {
        JSONObject auth = this.json.optJSONObject("auth");
        if (auth == null) {
            throw new RuntimeException("Bad data?");
        }
        boolean isRoot = false;
        JSONArray policyArray = auth.getJSONArray("policies");
        for (Object item : policyArray) {
            if (!String.valueOf(item).contains("root")) continue;
            isRoot = true;
            break;
        }
        return isRoot;
    }

    public ZonedDateTime expireTime() {
        if (this.lookupData == null) {
            throw new RuntimeException("lookupData is null - this is likely a programming error");
        }
        JSONObject data = this.lookupData.optJSONObject("data");
        if (data == null) {
            throw new RuntimeException("Bad data?");
        }
        Object obj = data.get("expire_time");
        if (obj == null) {
            return null;
        }
        String base = String.valueOf(obj);
        int stopIndex = base.indexOf(46);
        TemporalAccessor ta = dateFormatter.parse(base.substring(0, stopIndex));
        LocalDateTime d = LocalDateTime.from(ta);
        return d.atZone(ZoneId.systemDefault());
    }

    public List<String> errors() {
        JSONArray errors = this.json.optJSONArray("errors");
        ArrayList<String> list = new ArrayList<String>();
        errors.forEach(item -> list.add(String.valueOf(item)));
        return list;
    }

    public JSONObject getJson() {
        return this.json;
    }

    public String toString() {
        return this.json.toString(4);
    }

    public boolean isFromSuccessfulLoginRequest() {
        return this.fromSuccessfulLoginRequest;
    }

    public int hashCode() {
        if (this.fromSuccessfulLoginRequest) {
            return this.clientToken().hashCode();
        }
        return this.getJson().toString().hashCode();
    }

    public JSONObject getLookupData() {
        return this.lookupData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Token)) {
            return false;
        }
        try {
            Token other = (Token)obj;
            if (other.clientToken().equals(this.clientToken())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

