/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.AuthType;
import digital.toke.HousekeepingConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import okhttp3.HttpUrl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokeDriverConfig {
    private static final Logger logger = LogManager.getLogger(TokeDriverConfig.class);
    HousekeepingConfig housekeepingConfig;
    AuthType authType;
    String token;
    File tokenFile;
    String secretId;
    String roleId;
    String username;
    String password;
    String host = "127.0.0.1";
    String proto = "https";
    int port = -1;
    String vaultApiPrefix = "/v1";
    String defaultKVv1Name = "/secret";
    String defaultKVv2Name = "/secret";
    String kv1Name;
    String kv2Name;
    String authPath = "/auth";
    boolean renewable;
    static final String KVv2CONFIG = "/config";
    static final String KVv2DATA = "/data";
    static final String KVv2DELETE = "/delete";
    static final String KVv2UNDELETE = "/undelete";
    static final String KVv2REMOVE = "/remove";
    static final String KVv2METADATA = "/metadata";
    static final String KVv2DESTROY = "/destroy";

    public StringBuffer baseURL() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.proto);
        buf.append("://");
        buf.append(this.host);
        if (this.port != -1) {
            buf.append(":");
            buf.append(this.port);
        }
        buf.append(this.vaultApiPrefix);
        return buf;
    }

    public String authLdapLogin() {
        StringBuffer buf = this.baseURL();
        buf.append(this.authPath);
        buf.append("/ldap/login/");
        buf.append(this.username);
        return buf.toString();
    }

    public String authAppRoleLogin() {
        StringBuffer buf = this.baseURL();
        buf.append(this.authPath);
        buf.append("/approle/login");
        return buf.toString();
    }

    public String authUserPassLogin() {
        StringBuffer buf = this.baseURL();
        buf.append(this.authPath);
        buf.append("/userpass/login/");
        buf.append(this.username);
        return buf.toString();
    }

    public String authTokenLogin() {
        StringBuffer buf = this.baseURL();
        buf.append(this.authPath);
        buf.append("/token/create");
        return buf.toString();
    }

    public String authTokenLookup() {
        StringBuffer buf = this.baseURL();
        buf.append(this.authPath);
        buf.append("/token/lookup");
        return buf.toString();
    }

    public String authTokenLookupSelf() {
        StringBuffer buf = this.baseURL();
        buf.append(this.authPath);
        buf.append("/token/lookup-self");
        return buf.toString();
    }

    public String authTokenRenew() {
        StringBuffer buf = this.baseURL();
        buf.append(this.authPath);
        buf.append("/token/renew");
        return buf.toString();
    }

    public String authTokenRenewSelf() {
        StringBuffer buf = this.baseURL();
        buf.append(this.authPath);
        buf.append("/token/renew-self");
        return buf.toString();
    }

    public String kv2Config() {
        StringBuffer buf = this.baseURL();
        if (this.kv2Name == null) {
            buf.append(this.defaultKVv2Name);
        } else {
            if (!this.kv2Name.startsWith("/")) {
                buf.append("/");
            }
            buf.append(this.kv2Name);
        }
        buf.append(KVv2CONFIG);
        return buf.toString();
    }

    public String kv2Path(String verb, String path) {
        StringBuffer buf = this.baseURL();
        if (this.kv2Name == null) {
            buf.append(this.defaultKVv2Name);
        } else {
            if (!this.kv2Name.startsWith("/")) {
                buf.append("/");
            }
            buf.append(this.kv2Name);
        }
        buf.append(verb);
        if (path != null) {
            if (path.charAt(0) != '/') {
                buf.append("/");
            }
            buf.append(path);
        }
        return buf.toString();
    }

    public HttpUrl kv2List(String path) {
        StringBuffer segments = new StringBuffer("v1");
        if (this.kv2Name == null) {
            segments.append(this.defaultKVv2Name);
        } else {
            if (!this.kv2Name.startsWith("/")) {
                segments.append("/");
            }
            segments.append(this.kv2Name);
        }
        segments.append(KVv2METADATA);
        if (path != null) {
            if (path.charAt(0) != '/') {
                segments.append("/");
            }
            segments.append(path);
        }
        HttpUrl url = new HttpUrl.Builder().scheme(this.proto).host(this.host).port(this.port).addPathSegments(segments.toString()).addQueryParameter("list", "true").build();
        return url;
    }

    public String kv1Path(String path) {
        StringBuffer buf = this.baseURL();
        if (this.kv1Name == null) {
            buf.append(this.defaultKVv1Name);
        } else {
            if (!this.kv1Name.startsWith("/")) {
                buf.append("/");
            }
            buf.append(this.kv1Name);
        }
        if (path != null) {
            if (path.charAt(0) != '/') {
                buf.append("/");
            }
            buf.append(path);
        }
        return buf.toString();
    }

    public HttpUrl kv1List(String path) {
        StringBuffer segments = new StringBuffer("v1");
        if (this.kv1Name == null) {
            segments.append(this.defaultKVv1Name);
        } else {
            if (!this.kv1Name.startsWith("/")) {
                segments.append("/");
            }
            segments.append(this.kv1Name);
        }
        if (path != null) {
            if (path.charAt(0) != '/') {
                segments.append("/");
            }
            segments.append(path);
        }
        HttpUrl url = new HttpUrl.Builder().scheme(this.proto).host(this.host).port(this.port).addPathSegments(segments.toString()).addQueryParameter("list", "true").build();
        return url;
    }

    public TokeDriverConfig host(String val) {
        this.host = val;
        return this;
    }

    public TokeDriverConfig proto(String val) {
        this.proto = val;
        return this;
    }

    public TokeDriverConfig port(int val) {
        this.port = val;
        return this;
    }

    public TokeDriverConfig vaultApiPrefix(String val) {
        this.vaultApiPrefix = val;
        return this;
    }

    public TokeDriverConfig defaultKVv1Name(String val) {
        this.defaultKVv1Name = val;
        return this;
    }

    public TokeDriverConfig defaultKVv2Name(String val) {
        this.defaultKVv2Name = val;
        return this;
    }

    public TokeDriverConfig authType(String val) {
        this.authType = AuthType.valueOf(val.toUpperCase());
        return this;
    }

    public TokeDriverConfig token(String val) {
        this.token = val;
        return this;
    }

    public TokeDriverConfig renewable(boolean b) {
        this.renewable = b;
        return this;
    }

    public TokeDriverConfig secretId(String val) {
        this.secretId = val;
        return this;
    }

    public TokeDriverConfig roleId(String val) {
        this.roleId = val;
        return this;
    }

    public TokeDriverConfig username(String val) {
        this.username = val;
        return this;
    }

    public TokeDriverConfig password(String val) {
        this.password = val;
        return this;
    }

    public TokeDriverConfig authPath(String val) {
        this.authPath = val;
        return this;
    }

    public TokeDriverConfig kvName(String val) {
        this.kv1Name = val;
        return this;
    }

    public TokeDriverConfig kv2Name(String val) {
        this.kv2Name = val;
        return this;
    }

    public TokeDriverConfig tokenFile(File fileWithToken) {
        this.tokenFile = fileWithToken;
        return this;
    }

    public String findToken() {
        if (this.tokenFile != null) {
            try {
                String t = new String(Files.readAllBytes(this.tokenFile.toPath()), "UTF-8");
                logger.debug("returning a token from file to use for auth");
                return t;
            }
            catch (IOException e) {
                logger.error("Failed to read file with token: " + this.tokenFile.getPath().toString());
                logger.error((Object)e);
            }
        } else if (this.token == null) {
            logger.error("Token asked for but not found in config, please fix this and try again.");
        } else {
            logger.debug("returning token from config, not file.");
            return this.token;
        }
        return null;
    }

    public HousekeepingConfig getHousekeepingConfig() {
        return this.housekeepingConfig;
    }

    public TokeDriverConfig housekeepingConfig(HousekeepingConfig housekeepingConfig) {
        this.housekeepingConfig = housekeepingConfig;
        return this;
    }
}

