/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.Auth;
import digital.toke.KVv1;
import digital.toke.KVv2;
import digital.toke.Networking;
import digital.toke.Sys;
import digital.toke.TokeDriverConfig;
import digital.toke.TokenManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokeDriver {
    private static final Logger logger = LogManager.getLogger(TokeDriver.class);
    final TokeDriverConfig config;
    final Networking httpClient;
    final TokenManager tokenManager;
    final Auth auth;
    final Sys sys;
    final KVv1 kvv1;
    final KVv2 kvv2;

    public TokeDriver(TokeDriverConfig config) {
        this.config = config;
        this.httpClient = new Networking();
        this.auth = new Auth(config, this.httpClient);
        this.tokenManager = new TokenManager(this.auth);
        this.tokenManager.addTokenListener(this.httpClient);
        this.sys = new Sys(config, this.httpClient);
        this.tokenManager.addTokenListener(this.sys);
        this.kvv1 = new KVv1(config, this.httpClient);
        this.tokenManager.addTokenListener(this.kvv1);
        this.kvv2 = new KVv2(config, this.httpClient);
        this.tokenManager.addTokenListener(this.kvv2);
        logger.info("Driver instance " + this.getClass().hashCode() + " initialized");
    }

    public Auth auth() {
        return this.auth;
    }

    public Sys sys() {
        return this.sys;
    }

    public KVv1 kv() {
        return this.kvv1;
    }

    public KVv2 kv2() {
        return this.kvv2;
    }
}

