/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.Networking;
import digital.toke.ServiceBase;
import digital.toke.TokeDriverConfig;
import digital.toke.Token;
import digital.toke.accessor.Toke;
import digital.toke.event.EventEnum;
import digital.toke.event.TokenEvent;
import digital.toke.event.TokenListener;
import digital.toke.exception.ConfigureException;
import digital.toke.exception.ReadException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Sys
extends ServiceBase
implements TokenListener {
    private static final Logger logger = LogManager.getLogger(Sys.class);
    protected TokeDriverConfig config;
    protected Token token;
    protected Networking client;

    public Sys(TokeDriverConfig config, Networking client) {
        this.config = config;
        this.client = client;
        logger.info("Initialized Sys driver instance");
    }

    @Override
    public void tokenEvent(TokenEvent evt) {
        if (evt.getType().equals((Object)EventEnum.LOGIN)) {
            this.token = evt.getToken();
            this.countDown();
            logger.info("Token with accessor " + this.token.accessor() + " set on Sys");
        }
        if (evt.getType().equals((Object)EventEnum.RELOAD_TOKEN)) {
            this.token = evt.getToken();
            logger.info("Reloaded token on a Sys instance.");
        }
    }

    public Toke capabilities(String token, String path) throws ReadException {
        ArrayList<String> paths = new ArrayList<String>(1);
        paths.add(path);
        return this.capabilities(token, paths);
    }

    public Toke capabilities(String token, List<String> paths) throws ReadException {
        this.latch();
        String url = this.config.baseURL().append("/sys/capabilities").toString();
        logger.debug("Using: " + url);
        JSONObject json = new JSONObject().put("token", (Object)token).put("paths", (Object)new JSONArray(paths));
        logger.debug(json.toString(4));
        try {
            Toke response = this.client.post(url, json.toString());
            this.readExceptionExcept(response, 200);
            return response;
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
    }

    public Toke capabilitiesSelf(List<String> paths) throws ReadException {
        this.latch();
        String url = this.config.baseURL().append("/sys/capabilities-self").toString();
        logger.debug("Using: " + url);
        JSONObject json = new JSONObject().put("paths", (Object)new JSONArray(paths));
        logger.debug(json.toString(4));
        try {
            Toke response = this.client.post(url, json.toString());
            this.readExceptionExcept(response, 200);
            return response;
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
    }

    public Toke health() throws ReadException {
        String url = this.config.baseURL().append("/sys/health").toString();
        try {
            return this.client.get(url);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
    }

    public Toke sealStatus() throws ReadException {
        String url = this.config.baseURL().append("/sys/seal-status").toString();
        try {
            return this.client.get(url);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
    }

    public Toke unseal(List<String> keys, boolean reset, boolean migrate) throws ConfigureException {
        Toke toke = null;
        for (String key : keys) {
            toke = this.unseal(key, reset, migrate);
        }
        return toke;
    }

    public Toke unseal(String key, boolean reset, boolean migrate) throws ConfigureException {
        this.latch();
        String url = this.config.baseURL().append("/sys/unseal").toString();
        logger.debug("Using: " + url);
        JSONObject json = new JSONObject().put("key", (Object)key).put("reset", reset).put("migrate", migrate);
        logger.debug(json.toString(4));
        try {
            Toke response = this.client.put(url, json.toString(), false);
            this.configureExceptionExcept(response, 200);
            return response;
        }
        catch (IOException e) {
            throw new ConfigureException(e);
        }
    }
}

