/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.Token;
import digital.toke.TokenRenewal;
import digital.toke.accessor.Toke;
import digital.toke.event.EventEnum;
import digital.toke.event.RenewalTokenEvent;
import digital.toke.event.TokenEvent;
import digital.toke.event.TokenListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Networking
implements TokenListener {
    private static final Logger logger = LogManager.getLogger(Networking.class);
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    protected final Lock lock = new ReentrantLock();
    protected final OkHttpClient client = new OkHttpClient();
    protected Token token;

    public Networking() {
        logger.info("Initialized a networking instance");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pingHost(String host, int port, int timeout) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
    }

    public boolean checkIsReachable(String hostname) {
        try {
            return InetAddress.getByName(hostname).isReachable(200);
        }
        catch (Exception x) {
            logger.error((Object)x);
            return false;
        }
    }

    public Toke get(String url) throws IOException {
        return this.get(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Toke get(String url, boolean withXVaultToken) throws IOException {
        this.lock.lock();
        try {
            boolean success;
            int code;
            String result;
            Request request = null;
            request = withXVaultToken ? new Request.Builder().url(url).header("X-Vault-Token", this.token.clientToken()).build() : new Request.Builder().url(url).build();
            try (Response response = this.client.newCall(request).execute();){
                result = response.body().string();
                code = response.code();
                success = response.isSuccessful();
            }
            Toke toke = new Toke(code, success, result);
            return toke;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Toke delete(String url) throws IOException {
        this.lock.lock();
        try {
            boolean success;
            int code;
            String result;
            Request request = new Request.Builder().delete().url(url).header("X-Vault-Token", this.token.clientToken()).build();
            try (Response response = this.client.newCall(request).execute();){
                result = response.body().string();
                code = response.code();
                success = response.isSuccessful();
            }
            Toke toke = new Toke(code, success, result);
            return toke;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Toke list(HttpUrl url) throws IOException {
        this.lock.lock();
        try {
            boolean success;
            int code;
            String result;
            Request request = new Request.Builder().url(url).header("X-Vault-Token", this.token.clientToken()).build();
            logger.debug(request.toString());
            try (Response response = this.client.newCall(request).execute();){
                result = response.body().string();
                code = response.code();
                success = response.isSuccessful();
            }
            Toke toke = new Toke(code, success, result);
            return toke;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Toke login(String url, String json) throws IOException {
        this.lock.lock();
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            Request request = new Request.Builder().url(url).post(body).build();
            try (Response response = this.client.newCall(request).execute();){
                Toke toke = new Toke(response.code(), response.isSuccessful(), response.body().string());
                return toke;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Toke loginToken(String url, String json, String clientToken) throws IOException {
        this.lock.lock();
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            Request request = new Request.Builder().url(url).post(body).header("X-Vault-Token", clientToken).build();
            try (Response response = this.client.newCall(request).execute();){
                Toke toke = new Toke(response.code(), response.isSuccessful(), response.body().string());
                return toke;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Toke post(String url, String json) throws IOException {
        this.lock.lock();
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            Request request = new Request.Builder().url(url).post(body).header("X-Vault-Token", this.token.clientToken()).build();
            try (Response response = this.client.newCall(request).execute();){
                Toke toke = new Toke(response.code(), response.isSuccessful(), response.body().string());
                return toke;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Toke put(String url, String json, boolean withXVaultToken) throws IOException {
        this.lock.lock();
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            Request request = null;
            request = withXVaultToken ? new Request.Builder().url(url).put(body).header("X-Vault-Token", this.token.clientToken()).build() : new Request.Builder().url(url).put(body).build();
            try (Response response = this.client.newCall(request).execute();){
                Toke toke = new Toke(response.code(), response.isSuccessful(), response.body().string());
                return toke;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void tokenEvent(TokenEvent evt) {
        if (evt.getType().equals((Object)EventEnum.RENEWAL)) {
            RenewalTokenEvent thisEvt = (RenewalTokenEvent)evt;
            for (TokenRenewal tr : thisEvt.getList()) {
                if (!tr.oldToken.clientToken().equals(this.token.clientToken())) continue;
                this.token = tr.newToken;
                break;
            }
            logger.info("Token with accessor " + this.token.accessor() + " set on Networking instance");
            return;
        }
        if (evt.getType().equals((Object)EventEnum.LOGIN)) {
            this.token = evt.getToken();
            logger.info("Token with accessor " + this.token.accessor() + " set on Networking instance");
            return;
        }
        if (evt.getType().equals((Object)EventEnum.RELOAD_TOKEN)) {
            this.token = evt.getToken();
            logger.info("Reloaded token on Networking instance.");
            return;
        }
    }
}

