/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.KV;
import digital.toke.Networking;
import digital.toke.TokeDriverConfig;
import digital.toke.accessor.Toke;
import digital.toke.exception.ConfigureException;
import digital.toke.exception.ReadException;
import digital.toke.exception.WriteException;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class KVv2
extends KV {
    private static final Logger logger = LogManager.getLogger(KVv2.class);

    public KVv2(TokeDriverConfig config, Networking client) {
        super(config, client);
        logger.info("Initialized KVv2 driver instance");
    }

    public Toke kvRead(String path) throws ReadException {
        if (this.token == null) {
            throw new ReadException("Token not set");
        }
        return this.kvRead(path, -1);
    }

    public Toke kvRead(String path, int version) throws ReadException {
        this.latch();
        if (this.token == null) {
            throw new ReadException("Token not set");
        }
        String url = this.config.kv2Path("/data", path);
        if (version != -1) {
            url = url + "?version=" + version;
        }
        Toke response = null;
        try {
            response = this.client.get(url);
            this.readExceptionExcept(response, 200);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        return response;
    }

    public Toke kvConfigure(int max_versions, boolean cas_required) throws ConfigureException {
        this.latch();
        if (this.token == null) {
            throw new ConfigureException("Token not set");
        }
        String url = this.config.kv2Path("/config", null);
        JSONObject json = new JSONObject();
        json.put("max_versions", max_versions);
        json.put("cas_required", cas_required);
        try {
            Toke response = this.client.post(url, json.toString());
            this.configureExceptionExcept(response, 204);
            return response;
        }
        catch (IOException e) {
            throw new ConfigureException(e);
        }
    }

    public Toke kvReadConfig() throws ReadException {
        this.latch();
        if (this.token == null) {
            throw new ReadException("Token not set");
        }
        String url = this.config.kv2Path("/config", null);
        Toke response = null;
        try {
            response = this.client.get(url);
            this.readExceptionExcept(response, 200);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        return response;
    }

    public Toke kvWriteIfKeyDoesntExist(String path, Map<String, Object> data) throws WriteException {
        JSONObject top = new JSONObject().put("data", data);
        top.put("options", (Object)new JSONObject().put("cas", 0));
        return this.kvCreateUpdate(path, top.toString());
    }

    public Toke kvWrite(String path, Map<String, Object> data) throws WriteException {
        JSONObject top = new JSONObject().put("data", data);
        return this.kvCreateUpdate(path, top.toString());
    }

    public Toke kvWrite(String path, JSONObject json) throws WriteException {
        if (this.token == null) {
            throw new WriteException("Token not set");
        }
        return this.kvCreateUpdate(path, json.toString());
    }

    public Toke kvWriteVersion(String path, Map<String, Object> data, int version) throws WriteException {
        JSONObject top = new JSONObject().put("data", data);
        top.put("options", (Object)new JSONObject().put("cas", version));
        return this.kvCreateUpdate(path, top.toString());
    }

    public Toke kvCreateUpdate(String path, String jsonData) throws WriteException {
        this.latch();
        if (this.token == null) {
            throw new WriteException("Token not set");
        }
        String url = this.config.kv2Path("/data", path);
        logger.debug(url);
        logger.debug(jsonData.toString());
        try {
            Toke response = this.client.post(url, jsonData);
            logger.debug((Object)response);
            this.writeExceptionExcept(response, 200);
            return response;
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
    }

    public Toke kvList(String path) throws ReadException {
        this.latch();
        if (this.token == null) {
            throw new ReadException("Token not set");
        }
        Toke response = null;
        try {
            response = this.client.list(this.config.kv2List(path));
            logger.debug((Object)response);
            this.readExceptionExcept(response, 200);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        return response;
    }

    public Toke kvReadMetadata(String path) throws ReadException {
        this.latch();
        if (this.token == null) {
            throw new ReadException("Token not set");
        }
        String url = this.config.kv2Path("/metadata", path);
        Toke response = null;
        try {
            response = this.client.get(url);
            this.readExceptionExcept(response, 200);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        return response;
    }

    public Toke kvDestroy(String path, int[] versions) throws WriteException {
        this.latch();
        if (this.token == null) {
            throw new WriteException("Token not set");
        }
        String url = this.config.kv2Path("/destroy", path);
        JSONObject obj = new JSONObject().put("versions", (Object)versions);
        Toke response = null;
        try {
            response = this.client.post(url, obj.toString());
            this.writeExceptionExcept(response, 204);
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
        return response;
    }

    public Toke kvDelete(String path) throws WriteException {
        this.latch();
        if (this.token == null) {
            throw new WriteException("Token not set");
        }
        String url = this.config.kv2Path("/data", path);
        Toke response = null;
        try {
            response = this.client.delete(url);
            this.writeExceptionExcept(response, 204);
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
        return response;
    }

    public Toke kvDelete(String path, int[] versionsToDelete) throws WriteException {
        this.latch();
        if (this.token == null) {
            throw new WriteException("Token not set");
        }
        String url = this.config.kv2Path("/delete", path);
        JSONObject obj = new JSONObject().put("versions", (Object)versionsToDelete);
        Toke response = null;
        try {
            response = this.client.post(url, obj.toString());
            this.writeExceptionExcept(response, 200);
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
        return response;
    }

    public Toke kvUndelete(String path, int[] versionsToUndelete) throws WriteException {
        this.latch();
        if (this.token == null) {
            throw new WriteException("Token not set");
        }
        String url = this.config.kv2Path("/undelete", path);
        JSONObject obj = new JSONObject().put("versions", (Object)versionsToUndelete);
        Toke response = null;
        try {
            response = this.client.post(url, obj.toString());
            this.writeExceptionExcept(response, 204);
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
        return response;
    }
}

