/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.KV;
import digital.toke.Networking;
import digital.toke.TokeDriverConfig;
import digital.toke.accessor.Toke;
import digital.toke.exception.ReadException;
import digital.toke.exception.WriteException;
import java.io.IOException;
import java.util.Map;
import okhttp3.HttpUrl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class KVv1
extends KV {
    private static final Logger logger = LogManager.getLogger(KVv1.class);

    public KVv1(TokeDriverConfig config, Networking client) {
        super(config, client);
        logger.info("Initialized KVv1 driver instance");
    }

    public Toke kvRead(String path) throws ReadException {
        this.latch();
        String url = this.config.kv1Path(path);
        Toke response = null;
        try {
            response = this.client.get(url);
            this.readExceptionExcept(response, 200);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        return response;
    }

    public Toke kvWrite(String path, JSONObject obj) throws WriteException {
        return this.kvCreateUpdate(path, obj.toString());
    }

    public Toke kvWrite(String path, Map<String, Object> map) throws WriteException {
        JSONObject obj = new JSONObject(map);
        return this.kvCreateUpdate(path, obj.toString());
    }

    private Toke kvCreateUpdate(String path, String jsonData) throws WriteException {
        this.latch();
        String url = this.config.kv1Path(path);
        logger.debug("Using: " + url);
        try {
            Toke response = this.client.post(url, jsonData);
            this.writeExceptionExcept(response, 204);
            return response;
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
    }

    public Toke kvList(String path) throws ReadException {
        this.latch();
        HttpUrl url = this.config.kv1List(path);
        Toke response = null;
        try {
            response = this.client.list(url);
            this.readExceptionExcept(response, 200);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        return response;
    }

    public Toke kvDelete(String path) throws WriteException {
        this.latch();
        String url = this.config.kv1Path(path);
        Toke response = null;
        try {
            response = this.client.delete(url);
            this.writeExceptionExcept(response, 204);
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
        return response;
    }
}

