/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.Networking;
import digital.toke.ServiceBase;
import digital.toke.TokeDriverConfig;
import digital.toke.Token;
import digital.toke.TokenRenewal;
import digital.toke.event.EventEnum;
import digital.toke.event.RenewalTokenEvent;
import digital.toke.event.TokenEvent;
import digital.toke.event.TokenListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class KV
extends ServiceBase
implements TokenListener {
    private static final Logger logger = LogManager.getLogger(KV.class);
    protected TokeDriverConfig config;
    protected Token token;
    protected Networking client;

    public KV(TokeDriverConfig config, Networking client) {
        this.config = config;
        this.client = client;
    }

    @Override
    public void tokenEvent(TokenEvent evt) {
        if (evt.getType().equals((Object)EventEnum.RENEWAL)) {
            RenewalTokenEvent thisEvt = (RenewalTokenEvent)evt;
            for (TokenRenewal tr : thisEvt.getList()) {
                if (!tr.oldToken.clientToken().equals(this.token.clientToken())) continue;
                this.token = tr.newToken;
                break;
            }
            logger.info("Token with accessor " + this.token.accessor() + " set on Networking instance");
            return;
        }
        if (evt.getType().equals((Object)EventEnum.LOGIN)) {
            this.token = evt.getToken();
            this.countDown();
            logger.info("Token with accessor " + this.token.accessor() + " set on " + this.getClass().getName());
            return;
        }
        if (evt.getType().equals((Object)EventEnum.RELOAD_TOKEN)) {
            this.token = evt.getToken();
            logger.info("Reloaded token on " + this.getClass().getName());
            return;
        }
    }
}

