/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class HousekeepingConfig {
    boolean unseal = false;
    List<String> unsealKeys;
    boolean renew = true;
    long period = 300L;
    long min_ttl = 1800L;
    boolean testReachable = true;
    boolean pingHost = true;

    public static HousekeepingConfig defaultInstance() {
        return new HousekeepingConfig();
    }

    List<String> getUnsealKeys() {
        return this.unsealKeys;
    }

    public HousekeepingConfig unseal(boolean attemptToUnseal) {
        this.unseal = attemptToUnseal;
        return this;
    }

    public HousekeepingConfig renew(boolean attemptToRenewTokens) {
        this.renew = attemptToRenewTokens;
        return this;
    }

    public HousekeepingConfig period(int periodInSeconds) {
        this.period = periodInSeconds;
        return this;
    }

    public HousekeepingConfig minttl(int minInSeconds) {
        this.min_ttl = minInSeconds;
        return this;
    }

    public HousekeepingConfig pingHost(boolean pingHost) {
        this.pingHost = pingHost;
        return this;
    }

    public HousekeepingConfig reachable(boolean testReachable) {
        this.testReachable = testReachable;
        return this;
    }

    public HousekeepingConfig unsealKeys(List<String> keys) {
        this.unsealKeys = keys;
        return this;
    }

    public HousekeepingConfig unsealKeys(File keyFile) throws IOException {
        this.unsealKeys = new ArrayList<String>();
        Files.lines(keyFile.toPath()).forEach(item -> {
            if (item != null && item.trim().length() > 0) {
                this.unsealKeys.add((String)item);
            }
        });
        return this;
    }
}

